/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.hprose;

import hprose.common.FilterHandler;
import hprose.common.HproseFilter;
import hprose.common.InvokeHandler;
import hprose.io.HproseMode;
import hprose.server.HproseServiceEvent;
import hprose.server.HproseTcpServer;
import java.io.IOException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;

public class HproseTcpServiceExporter
extends RemoteExporter
implements InitializingBean {
    private HproseTcpServer tcpServer;
    private String host;
    private int port = 0;
    private boolean debug = true;
    private HproseServiceEvent event = null;
    private HproseMode mode = HproseMode.MemberMode;
    private HproseFilter filter = null;
    private InvokeHandler invokeHandler = null;
    private FilterHandler beforeFilterHandler = null;
    private FilterHandler afterFilterHandler = null;

    public void afterPropertiesSet() throws Exception {
        this.checkService();
        this.checkServiceInterface();
        Object service = this.getService();
        Class cls = this.getServiceInterface();
        this.tcpServer = new HproseTcpServer(this.host, this.port);
        this.tcpServer.add(service, cls);
        this.tcpServer.setDebugEnabled(this.debug);
        this.tcpServer.setEvent(this.event);
        this.tcpServer.setMode(this.mode);
        this.tcpServer.setFilter(this.filter);
        this.tcpServer.use(this.invokeHandler);
        this.tcpServer.beforeFilter.use(this.beforeFilterHandler);
        this.tcpServer.afterFilter.use(this.afterFilterHandler);
    }

    public void setDebugEnabled(boolean value) {
        this.debug = value;
    }

    public void setEvent(HproseServiceEvent value) {
        this.event = value;
    }

    public void setMode(HproseMode value) {
        this.mode = value;
    }

    public void setFilter(HproseFilter value) {
        this.filter = value;
    }

    public void setInvokeHandler(InvokeHandler value) {
        this.invokeHandler = value;
    }

    public void setBeforeFilterHandler(FilterHandler value) {
        this.beforeFilterHandler = value;
    }

    public void setAfterFilterHandler(FilterHandler value) {
        this.afterFilterHandler = value;
    }

    public void setHost(String value) {
        this.host = value;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public void start() throws IOException {
        this.tcpServer.start();
    }

    public void stop() {
        this.tcpServer.stop();
    }
}

