/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class RedisShardClient {
    private String addresses;
    private List<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
    ShardedJedisPool pool;

    public void init() {
        String[] host;
        for (String item : host = this.addresses.split(",")) {
            String[] tmp = item.split(":");
            this.shards.add(new JedisShardInfo(tmp[0], Integer.parseInt(tmp[1])));
        }
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMinIdle(8);
        config.setMaxIdle(100);
        config.setMaxTotal(10000);
        config.setMaxWaitMillis(3000L);
        config.setTestOnBorrow(true);
        config.setTestOnCreate(true);
        this.pool = new ShardedJedisPool(config, this.shards);
    }

    public void destory() {
        this.pool.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(String key, String ... members) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Long l = resource.srem(key, members);
            return l;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Set set = resource.smembers(key);
            return set;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(String key, String ... members) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Long l = resource.sadd(key, members);
            return l;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            String string = resource.get(key);
            return string;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            String string = resource.set(key, value);
            return string;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(String key, int seconds, String value) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            String string = resource.setex(key, seconds, value);
            return string;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(String key, String value) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Long l = resource.setnx(key, value);
            return l;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSet(String key, String value) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            String string = resource.getSet(key, value);
            return string;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Long l = resource.del(key);
            return l;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(String key, int seconds) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Long l = resource.expire(key, seconds);
            return l;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, String member) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Long l = resource.zadd(key, 1.0, member);
            return l;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(String key, double score, String member) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Long l = resource.zadd(key, score, member);
            return l;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrange(String key, long start, long end) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Set set = resource.zrange(key, start, end);
            return set;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrange(String key, long start, long end) {
        ShardedJedis resource = null;
        try {
            resource = this.pool.getResource();
            Set set = resource.zrevrange(key, start, end);
            return set;
        }
        finally {
            this.pool.returnResource(resource);
        }
    }

    public String getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }
}

