/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.http;

import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    public static String addParam(String url, String paramName, String paramValue) {
        if (null != paramName && !"".equals(paramName)) {
            url = url + (url.indexOf("?") < 0 ? "?" : "&");
            url = url + paramName + "=";
            if (null != paramValue && !"".equals(paramValue)) {
                url = url + paramValue;
            }
        }
        return url;
    }

    public static String getDomainByRequest(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        if ((url = url.delete(0, url.toString().indexOf("."))).indexOf(":") > 0) {
            url = url.delete(url.indexOf(":"), url.length());
        }
        if (url.indexOf("/") > 0) {
            url = url.delete(url.indexOf("/"), url.length());
        }
        return url.toString();
    }

    public static String getDomainByRequest(String url) {
        StringBuffer urlBuffer = new StringBuffer(url);
        if ((urlBuffer = urlBuffer.delete(0, urlBuffer.toString().indexOf("."))).indexOf(":") > 0) {
            urlBuffer = urlBuffer.delete(urlBuffer.indexOf(":"), urlBuffer.length());
        }
        if (urlBuffer.indexOf("/") > 0) {
            urlBuffer = urlBuffer.delete(urlBuffer.indexOf("/"), urlBuffer.length());
        }
        return urlBuffer.toString();
    }

    public static String getResByCompleteUrl(String url) {
        StringBuffer urlBuffer = new StringBuffer(url);
        if ((urlBuffer = urlBuffer.delete(0, urlBuffer.toString().indexOf("."))).indexOf("/") > 0) {
            urlBuffer = urlBuffer.delete(0, urlBuffer.indexOf("/"));
        }
        return urlBuffer.toString();
    }

    public static String buildRequestUrl(HttpServletRequest request) {
        StringBuilder buffer = new StringBuilder();
        String requestUrlFromHeader = request.getHeader("x-request-url");
        if (null != requestUrlFromHeader && !"".equals(requestUrlFromHeader)) {
            buffer.append(requestUrlFromHeader);
        } else {
            buffer.append(request.isSecure() ? "https://" : "http://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getRequestURI());
        }
        return buffer.toString();
    }

    public static String appendQueryStr(HttpServletRequest request, String url) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(url);
        String queryStr = request.getQueryString();
        if (null != queryStr && !"".equals(queryStr)) {
            buffer.append("?");
            buffer.append(queryStr);
        }
        return buffer.toString();
    }

    public static String removeParameter(String url, String paramName) {
        if (null == paramName || "".equals(paramName)) {
            return url;
        }
        if (url.indexOf(paramName) < 0) {
            return url;
        }
        ParamOffsets paramOffsets = RequestUtil.getParamOffsets(url, paramName);
        if (paramOffsets != null) {
            StringBuilder sb = new StringBuilder(url);
            int paramEnd = paramOffsets.nameStart + paramName.length();
            if (paramOffsets.valStart >= 0) {
                paramEnd = paramOffsets.valEnd;
            }
            int separatorIndex = paramOffsets.nameStart - 1;
            char separator = sb.charAt(separatorIndex);
            sb.replace(separatorIndex, paramEnd + 1, "");
            if (sb.length() > separatorIndex) {
                sb.setCharAt(separatorIndex, separator);
            }
            return sb.toString();
        }
        return url;
    }

    private static ParamOffsets getParamOffsets(String url, String paramName) {
        if (null == paramName || "".equals(paramName)) {
            return null;
        }
        int lastCharIndex = url.length() - 1;
        int paramSeparator = 63;
        int startIndex = 0;
        while (startIndex <= lastCharIndex) {
            int nextParamIndex = url.indexOf(paramSeparator, startIndex);
            if (nextParamIndex < 0) {
                return null;
            }
            int paramNameIndex = nextParamIndex + 1;
            int charAfterParamNameIndex = paramNameIndex + paramName.length();
            if (charAfterParamNameIndex > lastCharIndex) {
                return null;
            }
            if (url.charAt(charAfterParamNameIndex) == '=' && url.regionMatches(paramNameIndex, paramName, 0, paramName.length())) {
                ParamOffsets paramOffsets = new ParamOffsets();
                paramOffsets.nameStart = paramNameIndex;
                int paramValueIndex = charAfterParamNameIndex + 1;
                if (paramValueIndex <= lastCharIndex && url.charAt(paramValueIndex) != '&') {
                    paramOffsets.valStart = paramValueIndex;
                    nextParamIndex = url.indexOf(38, paramValueIndex);
                    paramOffsets.valEnd = nextParamIndex == -1 ? url.length() - 1 : nextParamIndex - 1;
                }
                return paramOffsets;
            }
            paramSeparator = 38;
            startIndex = paramNameIndex;
        }
        return null;
    }

    private static class ParamOffsets {
        int nameStart = -1;
        int valStart = -1;
        int valEnd = -1;

        private ParamOffsets() {
        }
    }
}

