/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sms.model.v20160927.SingleSendSmsRequest;
import com.junxin.util.aliyun.AliYunSms;
import com.junxin.util.bean.JacksonMapperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALiYunSmsUtil {
    private static Logger logger = LoggerFactory.getLogger(ALiYunSmsUtil.class);
    private String accessKeyId = "";
    private String accessKeySecret = "";
    private String endpointName = "";
    private String regionId = "";
    private String product = "";
    private String domain = "";
    private String signName = "i\u91d1\u725b\u5ea7";
    private String appName = "i\u91d1\u725b\u5ea7";

    public Boolean sendSms(String phone, String code, String item, String templateCode) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.regionId, (String)this.accessKeyId, (String)this.accessKeySecret);
        DefaultProfile.addEndpoint((String)this.endpointName, (String)this.regionId, (String)this.product, (String)this.domain);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        SingleSendSmsRequest request = new SingleSendSmsRequest();
        try {
            request.setSignName(this.signName);
            request.setTemplateCode(templateCode);
            request.setParamString(new AliYunSms(code, this.appName).toString());
            request.setRecNum(phone);
            HttpResponse httpResponse = client.doAction((AcsRequest)request, true, 3);
            logger.error(JacksonMapperUtil.beanToJson(httpResponse));
            if (200 == httpResponse.getStatus()) {
                return true;
            }
            return false;
        }
        catch (ServerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (ClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Boolean sendRegistSms(String phone, String code) {
        try {
            return this.sendSms(phone, code, null, "SMS_25185020");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Boolean sendUpdatePasswordSms(String phone, String code) {
        try {
            return this.sendSms(phone, code, null, "SMS_25185018");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Boolean sendBankCard(String phone, String code) {
        try {
            return this.sendSms(phone, code, null, "SMS_25185024");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void main(String[] args) {
        ALiYunSmsUtil aliyunsms = new ALiYunSmsUtil();
        aliyunsms.sendRegistSms("13520077078", "123456");
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

