/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.string;

public class BankCardUtil {
    public static boolean checkBankCard(String bankCard) {
        if (bankCard.length() < 15 || bankCard.length() > 19) {
            return false;
        }
        char bit = BankCardUtil.getBankCardCheckCode(bankCard.substring(0, bankCard.length() - 1));
        if (bit == 'N') {
            return false;
        }
        return bankCard.charAt(bankCard.length() - 1) == bit;
    }

    public static char getBankCardCheckCode(String nonCheckCodeBankCard) {
        if (nonCheckCodeBankCard == null || nonCheckCodeBankCard.trim().length() == 0 || !nonCheckCodeBankCard.matches("\\d+")) {
            return 'N';
        }
        char[] chs = nonCheckCodeBankCard.trim().toCharArray();
        int luhmSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhmSum += k;
            --i;
            ++j;
        }
        return luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
    }

    public static void main(String[] args) {
        BankCardUtil.checkBankCard("621483011656912");
        System.out.println(BankCardUtil.checkBankCard("6225768763185293"));
    }
}

