/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.redis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Hashing;
import redis.clients.util.Pool;

public class SentinelShardPool
extends Pool<ShardedJedis> {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public static final int MAX_RETRY_SENTINEL = 10;
    private int sentinelRetry = 0;
    protected Set<MasterListener> masterListeners = new HashSet<MasterListener>();
    private volatile List<HostAndPort> currentHostMasters;
    private GenericObjectPoolConfig redisPoolConfig;
    private int timeout = 2000;
    private String password;
    private int database = 0;
    private String masters;
    private String sentinels;

    public void init() {
        List<HostAndPort> masterList = this.initSentinels(this.sentinels, this.masters);
        this.initPool(masterList);
    }

    public void destroy() {
        for (MasterListener m : this.masterListeners) {
            m.shutdown();
        }
        super.destroy();
    }

    public List<HostAndPort> getCurrentHostMaster() {
        return this.currentHostMasters;
    }

    private void initPool(List<HostAndPort> masters) {
        if (!this.equals(this.currentHostMasters, masters)) {
            StringBuffer sb = new StringBuffer();
            for (HostAndPort master : masters) {
                sb.append(master.toString());
                sb.append(" ");
            }
            this.log.info("Created ShardedJedisPool to master at [" + sb.toString() + "]");
            List<JedisShardInfo> shardMasters = this.makeShardInfoList(masters);
            this.initPool(this.redisPoolConfig, new ShardedJedisFactory(shardMasters, Hashing.MURMUR_HASH, null));
            this.currentHostMasters = masters;
        }
    }

    private boolean equals(List<HostAndPort> currentShardMasters, List<HostAndPort> shardMasters) {
        if (currentShardMasters != null && shardMasters != null && currentShardMasters.size() == shardMasters.size()) {
            for (int i = 0; i < currentShardMasters.size(); ++i) {
                if (currentShardMasters.get(i).equals((Object)shardMasters.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<JedisShardInfo> makeShardInfoList(List<HostAndPort> masters) {
        ArrayList<JedisShardInfo> shardMasters = new ArrayList<JedisShardInfo>();
        for (HostAndPort master : masters) {
            JedisShardInfo jedisShardInfo = new JedisShardInfo(master.getHost(), master.getPort(), this.timeout);
            jedisShardInfo.setPassword(this.password);
            shardMasters.add(jedisShardInfo);
        }
        return shardMasters;
    }

    private List<HostAndPort> initSentinels(String sentinels, String masters) {
        HashMap<String, HostAndPort> masterMap = new HashMap<String, HostAndPort>();
        ArrayList<HostAndPort> shardMasters = new ArrayList<HostAndPort>();
        this.log.info("Trying to find all master from available Sentinels...");
        if (masters != null && masters.length() > 0) {
            String[] masterNames;
            for (String masterName : masterNames = masters.split(",")) {
                HostAndPort master = null;
                boolean fetched = false;
                while (!fetched && this.sentinelRetry < 10) {
                    if (sentinels != null && sentinels.length() > 0) {
                        String[] sentinelAddrs;
                        for (String sentinel : sentinelAddrs = sentinels.split(",")) {
                            HostAndPort hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
                            this.log.fine("Connecting to Sentinel " + hap);
                            try {
                                List hostAndPort;
                                Jedis jedis = new Jedis(hap.getHost(), hap.getPort());
                                master = (HostAndPort)masterMap.get(masterName);
                                if (master != null || (hostAndPort = jedis.sentinelGetMasterAddrByName(masterName)) == null || hostAndPort.size() <= 0) continue;
                                master = this.toHostAndPort(hostAndPort);
                                this.log.fine("Found Redis master at " + master);
                                shardMasters.add(master);
                                masterMap.put(masterName, master);
                                fetched = true;
                                jedis.disconnect();
                                break;
                            }
                            catch (JedisConnectionException e) {
                                this.log.warning("Cannot connect to sentinel running @ " + hap + ". Trying next one.");
                            }
                        }
                    }
                    if (null != master) continue;
                    try {
                        this.log.severe("All sentinels down, cannot determine where is " + masterName + " master is running... sleeping 1000ms, Will try again.");
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    fetched = false;
                    ++this.sentinelRetry;
                }
                if (fetched || this.sentinelRetry < 10) continue;
                this.log.severe("All sentinels down and try 10 times, Abort.");
                throw new JedisConnectionException("Cannot connect all sentinels, Abort.");
            }
            if (masterNames.length != 0 && masterNames.length == shardMasters.size()) {
                this.log.info("Starting Sentinel listeners...");
                if (sentinels != null && sentinels.length() > 0) {
                    String[] sentinelAddrs;
                    for (String sentinel : sentinelAddrs = sentinels.split(",")) {
                        HostAndPort hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
                        MasterListener masterListener = new MasterListener(Arrays.asList(masterNames), hap.getHost(), hap.getPort());
                        this.masterListeners.add(masterListener);
                        masterListener.start();
                    }
                }
            }
        }
        return shardMasters;
    }

    private HostAndPort toHostAndPort(List<String> getMasterAddrByNameResult) {
        String host = getMasterAddrByNameResult.get(0);
        int port = Integer.parseInt(getMasterAddrByNameResult.get(1));
        return new HostAndPort(host, port);
    }

    public GenericObjectPoolConfig getRedisPoolConfig() {
        return this.redisPoolConfig;
    }

    public void setRedisPoolConfig(GenericObjectPoolConfig redisPoolConfig) {
        this.redisPoolConfig = redisPoolConfig;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public String getMasters() {
        return this.masters;
    }

    public void setMasters(String masters) {
        this.masters = masters;
    }

    public String getSentinels() {
        return this.sentinels;
    }

    public void setSentinels(String sentinels) {
        this.sentinels = sentinels;
    }

    protected class MasterListener
    extends Thread {
        protected List<String> masters;
        protected String host;
        protected int port;
        protected long subscribeRetryWaitTimeMillis = 5000L;
        protected Jedis jedis;
        protected AtomicBoolean running = new AtomicBoolean(false);

        protected MasterListener() {
        }

        public MasterListener(List<String> masters, String host, int port) {
            this.masters = masters;
            this.host = host;
            this.port = port;
        }

        public MasterListener(List<String> masters, String host, int port, long subscribeRetryWaitTimeMillis) {
            this(masters, host, port);
            this.subscribeRetryWaitTimeMillis = subscribeRetryWaitTimeMillis;
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                this.jedis = new Jedis(this.host, this.port);
                try {
                    this.jedis.subscribe((JedisPubSub)new JedisPubSubAdapter(){

                        @Override
                        public void onMessage(String channel, String message) {
                            SentinelShardPool.this.log.fine("Sentinel " + MasterListener.this.host + ":" + MasterListener.this.port + " published: " + message + ".");
                            String[] switchMasterMsg = message.split(" ");
                            if (switchMasterMsg.length > 3) {
                                int index = MasterListener.this.masters.indexOf(switchMasterMsg[0]);
                                if (index >= 0) {
                                    HostAndPort newHostMaster = SentinelShardPool.this.toHostAndPort(Arrays.asList(switchMasterMsg[3], switchMasterMsg[4]));
                                    ArrayList<HostAndPort> newHostMasters = new ArrayList<HostAndPort>();
                                    for (int i = 0; i < MasterListener.this.masters.size(); ++i) {
                                        newHostMasters.add(null);
                                    }
                                    Collections.copy(newHostMasters, SentinelShardPool.this.currentHostMasters);
                                    newHostMasters.set(index, newHostMaster);
                                    SentinelShardPool.this.initPool(newHostMasters);
                                } else {
                                    StringBuffer sb = new StringBuffer();
                                    for (String masterName : MasterListener.this.masters) {
                                        sb.append(masterName);
                                        sb.append(",");
                                    }
                                    SentinelShardPool.this.log.fine("Ignoring message on +switch-master for master name " + switchMasterMsg[0] + ", our monitor master name are [" + sb + "]");
                                }
                            } else {
                                SentinelShardPool.this.log.severe("Invalid message received on Sentinel " + MasterListener.this.host + ":" + MasterListener.this.port + " on channel +switch-master: " + message);
                            }
                        }
                    }, new String[]{"+switch-master"});
                }
                catch (JedisConnectionException e) {
                    if (this.running.get()) {
                        SentinelShardPool.this.log.severe("Lost connection to Sentinel at " + this.host + ":" + this.port + ". Sleeping 5000ms and retrying.");
                        try {
                            Thread.sleep(this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        continue;
                    }
                    SentinelShardPool.this.log.fine("Unsubscribing from Sentinel at " + this.host + ":" + this.port);
                }
            }
        }

        public void shutdown() {
            try {
                SentinelShardPool.this.log.fine("Shutting down listener on " + this.host + ":" + this.port);
                this.running.set(false);
                this.jedis.disconnect();
            }
            catch (Exception e) {
                SentinelShardPool.this.log.severe("Caught exception while shutting down: " + e.getMessage());
            }
        }
    }

    protected class JedisPubSubAdapter
    extends JedisPubSub {
        protected JedisPubSubAdapter() {
        }

        public void onMessage(String channel, String message) {
        }

        public void onPMessage(String pattern, String channel, String message) {
        }

        public void onPSubscribe(String pattern, int subscribedChannels) {
        }

        public void onPUnsubscribe(String pattern, int subscribedChannels) {
        }

        public void onSubscribe(String channel, int subscribedChannels) {
        }

        public void onUnsubscribe(String channel, int subscribedChannels) {
        }
    }

    protected static class ShardedJedisFactory
    implements PooledObjectFactory<ShardedJedis> {
        private List<JedisShardInfo> shards;
        private Hashing algo;
        private Pattern keyTagPattern;

        public ShardedJedisFactory(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
            this.shards = shards;
            this.algo = algo;
            this.keyTagPattern = keyTagPattern;
        }

        public PooledObject<ShardedJedis> makeObject() throws Exception {
            ShardedJedis jedis = new ShardedJedis(this.shards, this.algo, this.keyTagPattern);
            return new DefaultPooledObject((Object)jedis);
        }

        public void destroyObject(PooledObject<ShardedJedis> pooledShardedJedis) throws Exception {
            ShardedJedis shardedJedis = (ShardedJedis)pooledShardedJedis.getObject();
            for (Jedis jedis : shardedJedis.getAllShards()) {
                try {
                    try {
                        jedis.quit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jedis.disconnect();
                }
                catch (Exception exception) {}
            }
        }

        public boolean validateObject(PooledObject<ShardedJedis> pooledShardedJedis) {
            try {
                ShardedJedis jedis = (ShardedJedis)pooledShardedJedis.getObject();
                for (Jedis shard : jedis.getAllShards()) {
                    if (shard.ping().equals("PONG")) continue;
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        public void activateObject(PooledObject<ShardedJedis> p) throws Exception {
        }

        public void passivateObject(PooledObject<ShardedJedis> p) throws Exception {
        }
    }
}

