/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;

public class RedisShardUtil {
    private static ShardedJedis jedis;

    public static void saveMap(String yncsid, Map<String, String> map, int authTimeout) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        jedis.hmset(yncsid, map);
        jedis.expire(yncsid, authTimeout);
        jedis.disconnect();
    }

    public static void saveList(String listKey, String listValue, int authTimeout) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        jedis.lpush(listKey, new String[]{listValue});
        jedis.expire(listKey, authTimeout);
        jedis.disconnect();
    }

    public static void saveSet(String setKey, String setValue, int authTimeout) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        jedis.sadd(setKey, new String[]{setValue});
        jedis.expire(setKey, authTimeout);
        jedis.disconnect();
    }

    public static void saveData(String key, String value, int authTimeout) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        jedis.set(key, value);
        jedis.expire(key, authTimeout);
        jedis.disconnect();
    }

    public static String getData(String key) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        String json = jedis.get(key);
        jedis.disconnect();
        return json;
    }

    public static String getDelData(String key) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        String json = jedis.getSet(key, "");
        if (null != json && !"".equals(json)) {
            jedis.del(key);
        }
        jedis.disconnect();
        return json;
    }

    public static String getData(String key, int seconds) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        String json = jedis.get(key);
        jedis.expire(key, seconds);
        jedis.disconnect();
        return json;
    }

    public static Map<String, String> getMap(String key) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        Map map = jedis.hgetAll(key);
        jedis.disconnect();
        return map;
    }

    public static List<String> getList(String key) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        List list = jedis.lrange(key, 0L, -1L);
        jedis.disconnect();
        return list;
    }

    public static Set<String> getSet(String key) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        Set list = jedis.smembers(key);
        jedis.disconnect();
        return list;
    }

    public static void expireByKey(String key, int seconds) {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        shards.add(new JedisShardInfo("127.0.0.1", 6379));
        jedis = new ShardedJedis(shards);
        jedis.expire(key, seconds);
        jedis.disconnect();
    }
}

