/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.file.upyun;

import com.junxin.util.file.FileManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import main.java.com.UpYun;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpYunFileManager
implements FileManager {
    private static final Logger logger = LoggerFactory.getLogger(UpYunFileManager.class);
    private static final String PARAM_SECRET = "secret";
    private String bucketName = "financial-platform";
    private String operatorName = "financial";
    private String operatorPwd = "nihao!@#";
    private int timeout = 60;
    private String fileServerUrl = "http://financial-platform.b0.upaiyun.com";

    @Override
    public boolean writeFile(String filePath, byte[] datas) throws IOException {
        return this.write(filePath, datas, null);
    }

    @Override
    public boolean writeFile(String filePath, byte[] datas, String secret) throws IOException {
        HashMap<String, String> params = null;
        if (StringUtils.isNotBlank((CharSequence)secret)) {
            params = new HashMap<String, String>();
            params.put(PARAM_SECRET, secret);
        }
        return this.write(filePath, datas, params);
    }

    @Override
    public boolean writeThumbPic(String filePath, byte[] datas, int width, int height) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(UpYun.PARAMS.KEY_X_GMKERL_TYPE.getValue(), UpYun.PARAMS.VALUE_FIX_BOTH.getValue());
        params.put(UpYun.PARAMS.KEY_X_GMKERL_VALUE.getValue(), width + "x" + height);
        params.put(UpYun.PARAMS.KEY_X_GMKERL_QUALITY.getValue(), "95");
        params.put(UpYun.PARAMS.KEY_X_GMKERL_UNSHARP.getValue(), "true");
        params.put(UpYun.PARAMS.KEY_X_GMKERL_THUMBNAIL.getValue(), "small");
        return this.write(filePath, datas, params);
    }

    private boolean write(String filePath, byte[] bytes, Map<String, String> params) throws IOException {
        String secret;
        Map filePathInfo;
        UpYun upyun = new UpYun(this.bucketName, this.operatorName, this.operatorPwd);
        upyun.setApiDomain("v0.api.upyun.com");
        upyun.setTimeout(this.timeout);
        upyun.setDebug(true);
        if (filePath == null || filePath.trim() == "") {
            logger.error("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a:{}", (Object)filePath);
            return false;
        }
        boolean auto = false;
        String rPath = StringUtils.removePattern((String)filePath, (String)"[\\w[.-]]+\\.[\\w]+");
        if (StringUtils.isNotBlank((CharSequence)rPath) && (filePathInfo = upyun.getFileInfo(rPath)) == null) {
            auto = true;
        }
        if (params != null && (secret = params.get(PARAM_SECRET)) != null && secret.trim() != "") {
            upyun.setFileSecret(secret);
            params.remove(PARAM_SECRET);
        }
        return upyun.writeFile(filePath, bytes, auto, null);
    }

    @Override
    public void redFile(String filePath, File file) {
        UpYun upyun = new UpYun(this.bucketName, this.operatorName, this.operatorPwd);
        upyun.setApiDomain("v0.api.upyun.com");
        upyun.setTimeout(this.timeout);
        upyun.setDebug(true);
        upyun.readFile(filePath, file);
    }

    public String getFileURL(String filePath, String secret) {
        StringBuffer buff = new StringBuffer(this.getFileServerUrl());
        buff.append(filePath);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{secret})) {
            buff.append("!").append(secret);
        }
        return buff.toString();
    }

    public List<Map<String, Object>> readDir(String filePath) {
        UpYun upyun = new UpYun(this.bucketName, this.operatorName, this.operatorPwd);
        List items = upyun.readDir(filePath);
        HashMap<String, Object> map = null;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (UpYun.FolderItem ft : items) {
            map = new HashMap<String, Object>();
            map.put("name", ft.name);
            map.put("type", ft.type);
            map.put("date", ft.date);
            map.put("size", ft.size);
            list.add(map);
        }
        return list;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorPwd() {
        return this.operatorPwd;
    }

    public void setOperatorPwd(String operatorPwd) {
        this.operatorPwd = operatorPwd;
    }

    public void setFileServerUrl(String fileServerUrl) {
        this.fileServerUrl = fileServerUrl;
    }

    public String getFileServerUrl() {
        return this.fileServerUrl;
    }
}

