/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtil {
    public static String fileRootPath;

    public void init(String fileRootPath) {
        FileUtil.fileRootPath = fileRootPath;
    }

    public static void saveFile(String newsRootPath, String filename, byte[] fileByte) throws IOException {
        File newsFileRoot = new File(newsRootPath);
        if (!newsFileRoot.exists()) {
            newsFileRoot.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(newsRootPath + filename);
        fos.write(fileByte);
        if (fos != null) {
            fos.close();
        }
    }

    public static boolean deleteFile(String filePath) {
        boolean flag = false;
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public static boolean deleteFolder(String filePath) {
        boolean flag = false;
        File file = new File(filePath);
        if (!file.exists()) {
            return flag;
        }
        if (file.isFile()) {
            return FileUtil.deleteFile(filePath);
        }
        return FileUtil.deleteDirectory(filePath);
    }

    public static boolean deleteDirectory(String filePath) {
        File dirFile;
        boolean flag = false;
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        if (!(dirFile = new File(filePath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtil.deleteFile(files[i].getAbsolutePath())) : !(flag = FileUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static byte[] readFile(String pic_path) {
        byte[] data = null;
        try {
            FileInputStream is = new FileInputStream(pic_path);
            int i = is.available();
            data = new byte[i];
            is.read(data);
            is.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public String getFileRootPath() {
        return fileRootPath;
    }

    public void setFileRootPath(String fileRootPath) {
        FileUtil.fileRootPath = fileRootPath;
    }
}

