/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.crypto;

import com.junxin.util.crypto.BASE64Decoder;
import com.junxin.util.crypto.BASE64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SignUtil {
    public static String encryptSign(String source, String pemPath) throws Exception {
        PrivateKey pk = SignUtil.getPrivateKeyByPath(pemPath);
        return SignUtil.sign(pk, source);
    }

    public static String encryptSign_(String source, String keyCode) {
        try {
            PrivateKey pk = SignUtil.getPrivateKey(keyCode);
            return SignUtil.sign(pk, source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String sign(PrivateKey pk, String source) throws Exception {
        byte[] sb = null;
        Signature sig = Signature.getInstance("SHA1withRSA");
        sig.initSign(pk);
        sig.update(source.getBytes());
        sb = sig.sign();
        return new BASE64Encoder().encode(sb);
    }

    public static Boolean checkSign(String source, String merSign, String pemPath) {
        try {
            PublicKey publicKey = SignUtil.getPublicKeyByPath(pemPath);
            return SignUtil.check(source, merSign, publicKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Boolean checkSign_(String source, String merSign, String keyCode) {
        try {
            PublicKey publicKey = SignUtil.getPublicKey(keyCode);
            return SignUtil.check(source, merSign, publicKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Boolean check(String source, String merSign, PublicKey publicKey) {
        try {
            Signature verifyalg = Signature.getInstance("SHA1withRSA");
            verifyalg.initVerify(publicKey);
            verifyalg.update(source.getBytes());
            byte[] signbyte = new BASE64Decoder().decodeBuffer(merSign);
            boolean status = verifyalg.verify(signbyte);
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static byte[] BASE64Decode(String source) throws IOException {
        return new BASE64Decoder().decodeBuffer(source);
    }

    public static PublicKey getPublicKeyByPath(String pubPemPath) {
        FileInputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            File file = new File(pubPemPath);
            if (file.exists()) {
                int tempbyte;
                in = new FileInputStream(file);
                byteOut = new ByteArrayOutputStream();
                while ((tempbyte = in.read()) != -1) {
                    byteOut.write(tempbyte);
                }
                PublicKey publicKey = SignUtil.getPublicKey(byteOut.toString());
                return publicKey;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u83b7\u53d6\u516c\u94a5\u5931\u8d25", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
    }

    public static PrivateKey getPrivateKeyByPath(String privatePemPath) {
        File file = new File(privatePemPath);
        FileInputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            int tempbyte;
            in = new FileInputStream(file);
            byteOut = new ByteArrayOutputStream();
            while ((tempbyte = in.read()) != -1) {
                byteOut.write(tempbyte);
            }
            PrivateKey privateKey = SignUtil.getPrivateKey(byteOut.toString());
            return privateKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u83b7\u53d6\u79c1\u94a5\u5931\u8d25", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static PublicKey getPublicKey(String keyCode) throws Exception {
        byte[] keybyte = SignUtil.BASE64Decode(keyCode);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keybyte);
        PublicKey publicKey = kf.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String keyCode) throws Exception {
        PrivateKey pk = null;
        PKCS8EncodedKeySpec peks = new PKCS8EncodedKeySpec(SignUtil.BASE64Decode(keyCode));
        KeyFactory kf = KeyFactory.getInstance("RSA");
        pk = kf.generatePrivate(peks);
        return pk;
    }
}

