/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.util.crypto;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.ArrayUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RSAUtil {
    private static Cipher cipher;
    private static Signature sig;

    public static Map<String, String> generateKeyPair(String filePath) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(1024);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            String publicKeyString = RSAUtil.getKeyString(publicKey);
            String privateKeyString = RSAUtil.getKeyString(privateKey);
            FileWriter pubfw = new FileWriter(filePath + "/pub.pem");
            FileWriter prifw = new FileWriter(filePath + "/prv.pem");
            BufferedWriter pubbw = new BufferedWriter(pubfw);
            BufferedWriter pribw = new BufferedWriter(prifw);
            pubbw.write(publicKeyString);
            pribw.write(privateKeyString);
            pubbw.flush();
            pubbw.close();
            pubfw.close();
            pribw.flush();
            pribw.close();
            prifw.close();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("publicKey", publicKeyString);
            map.put("privateKey", privateKeyString);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = new BASE64Decoder().decodeBuffer(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = new BASE64Decoder().decodeBuffer(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static String getKeyString(Key key) throws Exception {
        byte[] keyBytes = key.getEncoded();
        String s = new BASE64Encoder().encode(keyBytes);
        return s;
    }

    public static String encrypt(PrivateKey privateKey, String plainText) {
        try {
            sig.initSign(privateKey);
            sig.update(plainText.getBytes());
            byte[] sb = null;
            sb = sig.sign();
            return new BASE64Encoder().encode(sb);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String encrypt(String publicKeystore, String plainText) {
        try {
            String str;
            FileReader fr = new FileReader(publicKeystore);
            BufferedReader br = new BufferedReader(fr);
            String publicKeyString = "";
            while ((str = br.readLine()) != null) {
                publicKeyString = publicKeyString + str;
            }
            br.close();
            fr.close();
            sig.initSign(RSAUtil.getPrivateKey(publicKeystore));
            sig.update(plainText.getBytes());
            byte[] sb = null;
            sb = sig.sign();
            return new BASE64Encoder().encode(sb);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String decrypt(PrivateKey privateKey, String enStr) {
        try {
            cipher.init(2, privateKey);
            byte[] data = new BASE64Decoder().decodeBuffer(enStr);
            String dataReturn = null;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < data.length; i += 128) {
                byte[] doFinal = cipher.doFinal(ArrayUtils.subarray((byte[])data, (int)i, (int)(i + 128)));
                sb.append(new String(doFinal));
            }
            dataReturn = sb.toString();
            return new String(dataReturn);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String decrypt(String privateKeystore, String enStr) {
        try {
            String str;
            FileReader fr = new FileReader(privateKeystore);
            BufferedReader br = new BufferedReader(fr);
            String privateKeyString = "";
            while ((str = br.readLine()) != null) {
                privateKeyString = privateKeyString + str;
            }
            br.close();
            fr.close();
            cipher.init(2, RSAUtil.getPrivateKey(privateKeyString));
            byte[] data = new BASE64Decoder().decodeBuffer(enStr);
            String dataReturn = null;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < data.length; i += 128) {
                byte[] doFinal = cipher.doFinal(ArrayUtils.subarray((byte[])data, (int)i, (int)(i + 128)));
                sb.append(new String(doFinal));
            }
            dataReturn = sb.toString();
            return new String(dataReturn);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        try {
            cipher = Cipher.getInstance("RSA");
            sig = Signature.getInstance("SHA1withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }
}

