
/*
 * Copyright (C), 2013-2018, 北京君信微科科技有限公司
 * FileName: NumberUtil.java
 * Author:   ailikes
 * Date:     2018年6月28日 上午10:21:39
 * Description: //模块目的、功能描述      
 * History: //修改记录
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.junxin.util.number;

import java.math.BigDecimal;

/** 
 * 功能描述: 数字工具类
 * 
 * @version 1.0.0
 * @since 1.0.0 
 * @author ailikes
 * Date:   2018年6月28日 上午10:21:39
 */

public class NumberUtil {
    
    /**
     * 
     * 功能描述: Double 类型数值保留小数,默认保留两位小数,四舍五入
     * 
     * @param number 数值
     * @param decimal 小数位数
     * @return Double 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author ailikes 
     * Date:   2018年6月28日 上午10:23:52
     */
    public static Double doubleToFix(Double number,Integer decimal) {
        if(null == number) {
            return null;
        }
         return  new BigDecimal(number).setScale(null==decimal?2:decimal, BigDecimal.ROUND_HALF_UP).doubleValue();
    }
    
    /**
     * 
     * 功能描述: Float 类型数值保留小数,默认保留两位小数,四舍五入
     * 
     * @param number 数值
     * @param decimal 小数位数
     * @return float 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author ailikes 
     * Date:   2018年6月28日 上午10:23:52
     */
    public static Float floatToFix(Float number,Integer decimal) {
        if(null == number) {
            return null;
        }
         return  new BigDecimal(number).setScale(null==decimal?2:decimal, BigDecimal.ROUND_HALF_UP).floatValue();
    }
}

