/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.hprose;

import com.ailikes.util.ssl.SSLHelperUtil;
import hprose.client.HproseClient;
import hprose.client.HproseHttpClient;
import hprose.client.HproseTcpClient;
import hprose.common.FilterHandler;
import hprose.common.HproseFilter;
import hprose.common.InvokeHandler;
import hprose.io.HproseMode;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class HproseProxyFactoryBean
extends UrlBasedRemoteAccessor
implements FactoryBean {
    private HproseClient client = null;
    private Exception exception = null;
    private boolean keepAlive = true;
    private int keepAliveTimeout = 300;
    private int timeout = -1;
    private String proxyHost = null;
    private int proxyPort = 80;
    private String proxyUser = null;
    private String proxyPass = null;
    private HproseMode mode = HproseMode.MemberMode;
    private HproseFilter filter = null;
    private InvokeHandler invokeHandler = null;
    private FilterHandler beforeFilterHandler = null;
    private FilterHandler afterFilterHandler = null;
    private String certificatePath = null;
    private String certificatePassword = null;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        try {
            this.client = HproseClient.create((String)this.getServiceUrl(), (HproseMode)this.mode);
        }
        catch (Exception ex) {
            this.exception = ex;
        }
        if (this.client instanceof HproseHttpClient) {
            HproseHttpClient httpClient = (HproseHttpClient)this.client;
            SSLHelperUtil.SSLHelper(httpClient, this.certificatePath, this.certificatePassword);
            httpClient.setHeader("client", "jnzpc");
            httpClient.setKeepAlive(this.keepAlive);
            httpClient.setKeepAliveTimeout(this.keepAliveTimeout);
            httpClient.setTimeout(this.timeout);
            httpClient.setProxyHost(this.proxyHost);
            httpClient.setProxyPort(this.proxyPort);
            httpClient.setProxyUser(this.proxyUser);
            httpClient.setProxyPass(this.proxyPass);
            httpClient.use(this.invokeHandler);
            httpClient.beforeFilter.use(this.beforeFilterHandler);
            httpClient.afterFilter.use(this.afterFilterHandler);
        }
        if (this.client instanceof HproseTcpClient) {
            HproseTcpClient tcpClient = (HproseTcpClient)this.client;
            tcpClient.setTimeout(this.timeout);
        }
        this.client.setFilter(this.filter);
    }

    public void setKeepAlive(boolean value) {
        this.keepAlive = value;
    }

    public void setKeepAliveTimeout(int value) {
        this.keepAliveTimeout = value;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public void setProxyPort(int value) {
        this.proxyPort = value;
    }

    public void setProxyUser(String value) {
        this.proxyUser = value;
    }

    public void setProxyPass(String value) {
        this.proxyPass = value;
    }

    public void setTimeout(int value) {
        this.timeout = value;
    }

    public void setMode(HproseMode value) {
        this.mode = value;
    }

    public void setFilter(HproseFilter filter) {
        this.filter = filter;
    }

    public void setInvokeHandler(InvokeHandler value) {
        this.invokeHandler = value;
    }

    public void setBeforeFilterHandler(FilterHandler value) {
        this.beforeFilterHandler = value;
    }

    public void setAfterFilterHandler(FilterHandler value) {
        this.afterFilterHandler = value;
    }

    public Object getObject() throws Exception {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.client.useService(this.getServiceInterface());
    }

    public Class getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }
}

