/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util.thrift;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

public class ThriftServer
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(ThriftServer.class);
    private int port;
    private int selector = 16;
    private int worker = 1024;
    private TServer server;
    private ApplicationContext applicationContext;
    private String packageScan;

    public void start() throws TTransportException, NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.logger.info("start thrift server");
        TMultiplexedProcessor tprocessor = new TMultiplexedProcessor();
        Map beans = this.applicationContext.getBeansWithAnnotation(Service.class);
        Set entries = beans.entrySet();
        for (Map.Entry entry : entries) {
            Class<?>[] ints;
            Class<?> clazz = entry.getValue().getClass();
            String className = entry.getValue().toString();
            if (!className.startsWith(this.packageScan) || (ints = clazz.getInterfaces()) == null) continue;
            int count = ints.length;
            for (int i = 0; i < count; ++i) {
                Class<?> iFace = ints[i];
                String iNameThrift = iFace.getName();
                if (!iNameThrift.endsWith("Iface")) continue;
                String iName = iNameThrift.substring(0, iNameThrift.length() - 6);
                String name = iName.substring(iName.lastIndexOf(".") + 1, iName.length());
                Constructor<?> cons = Class.forName(iName + "$Processor").getConstructor(iFace);
                Object[] arguments = new Object[]{this.applicationContext.getBean(iFace)};
                tprocessor.registerProcessor(name, (TProcessor)cons.newInstance(arguments));
                this.logger.info("{} is ready.", (Object)name);
            }
        }
        TNonblockingServerSocket tnbSocketTransport = new TNonblockingServerSocket(this.port);
        TThreadedSelectorServer.Args tsArg = new TThreadedSelectorServer.Args((TNonblockingServerTransport)tnbSocketTransport);
        tsArg.selectorThreads(this.selector);
        tsArg.workerThreads(this.worker);
        tsArg.processor((TProcessor)tprocessor);
        tsArg.transportFactory((TTransportFactory)new TFramedTransport.Factory());
        tsArg.protocolFactory((TProtocolFactory)new TCompactProtocol.Factory());
        final TServer s = this.server = new TThreadedSelectorServer(tsArg);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                s.serve();
            }
        });
        t.start();
        this.logger.info("TThreadedSelectorServer selector={},worker={}", (Object)this.selector, (Object)this.worker);
        this.logger.info("thrift server is listening at port: {}", (Object)this.port);
    }

    public void stop() {
        this.server.stop();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSelector() {
        return this.selector;
    }

    public void setSelector(int selector) {
        this.selector = selector;
    }

    public int getWorker() {
        return this.worker;
    }

    public void setWorker(int worker) {
        this.worker = worker;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getPackageScan() {
        return this.packageScan;
    }

    public void setPackageScan(String packageScan) {
        this.packageScan = packageScan;
    }
}

