/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util.stf;

import com.jcraft.jsch.SftpProgressMonitor;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;

public class FileProgressMonitor
extends TimerTask
implements SftpProgressMonitor {
    private long progressInterval = 5000L;
    private boolean isEnd = false;
    private long transfered;
    private long fileSize;
    private Timer timer;
    private boolean isScheduled = false;

    public FileProgressMonitor(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public void run() {
        if (!this.isEnd()) {
            System.out.println("Transfering is in progress.");
            long transfered = this.getTransfered();
            if (transfered != this.fileSize) {
                System.out.println("Current transfered: " + transfered + " bytes");
                this.sendProgressMessage(transfered);
            } else {
                System.out.println("File transfering is done.");
                this.setEnd(true);
            }
        } else {
            System.out.println("Transfering done. Cancel timer.");
            this.stop();
            return;
        }
    }

    public void stop() {
        System.out.println("Try to stop progress monitor.");
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
            this.isScheduled = false;
        }
        System.out.println("Progress monitor stoped.");
    }

    public void start() {
        System.out.println("Try to start progress monitor.");
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.timer.schedule((TimerTask)this, 1000L, this.progressInterval);
        this.isScheduled = true;
        System.out.println("Progress monitor started.");
    }

    private void sendProgressMessage(long transfered) {
        if (this.fileSize != 0L) {
            double d = (double)transfered * 100.0 / (double)this.fileSize;
            DecimalFormat df = new DecimalFormat("#.##");
            System.out.println("Sending progress message: " + df.format(d) + "%");
        } else {
            System.out.println("Sending progress message: " + transfered);
        }
    }

    public boolean count(long count) {
        if (this.isEnd()) {
            return false;
        }
        if (!this.isScheduled) {
            this.start();
        }
        this.add(count);
        return true;
    }

    public void end() {
        this.setEnd(true);
        System.out.println("transfering end.");
    }

    private synchronized void add(long count) {
        this.transfered += count;
    }

    private synchronized long getTransfered() {
        return this.transfered;
    }

    public synchronized void setTransfered(long transfered) {
        this.transfered = transfered;
    }

    private synchronized void setEnd(boolean isEnd) {
        this.isEnd = isEnd;
    }

    private synchronized boolean isEnd() {
        return this.isEnd;
    }

    public void init(int op, String src, String dest, long max) {
    }
}

