/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util.redis.cluster;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public class RedisClusterClient {
    private String addresses;
    private Set<HostAndPort> jedisClusterNodes = new HashSet<HostAndPort>();
    private GenericObjectPoolConfig poolConfig;
    private JedisCluster jc;

    public void init() {
        String[] host;
        for (String item : host = this.addresses.split(",")) {
            String[] tmp = item.split(":");
            this.jedisClusterNodes.add(new HostAndPort(tmp[0], Integer.parseInt(tmp[1])));
        }
        if (this.poolConfig == null) {
            this.poolConfig = new GenericObjectPoolConfig();
            this.poolConfig.setMaxTotal(128);
            this.poolConfig.setMinIdle(8);
            this.poolConfig.setMaxIdle(16);
        }
        this.jc = new JedisCluster(this.jedisClusterNodes, this.poolConfig);
    }

    public Long srem(String key, String ... members) {
        return this.jc.srem(key, members);
    }

    public Set<String> smembers(String key) {
        return this.jc.smembers(key);
    }

    public Long sadd(String key, String ... members) {
        return this.jc.sadd(key, members);
    }

    public String get(String key) {
        return this.jc.get(key);
    }

    public String set(String key, String value) {
        return this.jc.set(key, value);
    }

    public String setex(String key, int seconds, String value) {
        return this.jc.setex(key, seconds, value);
    }

    public Long setnx(String key, String value) {
        return this.jc.setnx(key, value);
    }

    public String getSet(String key, String value) {
        return this.jc.getSet(key, value);
    }

    public Long del(String key) {
        return this.jc.del(key);
    }

    public Long expire(String key, int seconds) {
        return this.jc.expire(key, seconds);
    }

    public Long zadd(String key, String member) {
        return this.jc.zadd(key, 1.0, member);
    }

    public Long zadd(String key, double score, String member) {
        return this.jc.zadd(key, score, member);
    }

    public Set<String> zrange(String key, long start, long end) {
        return this.jc.zrange(key, start, end);
    }

    public Set<String> zrevrange(String key, long start, long end) {
        return this.jc.zrevrange(key, start, end);
    }

    public String getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public GenericObjectPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }
}

