/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util.filter;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(LogFilter.class);
    public static final String callIdKey = "callId";

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String callId = UUID.randomUUID().toString().replace("-", "");
        MDC.put((String)callIdKey, (String)callId);
        String url = req.getRequestURL().toString();
        logger.info("{}?{}", (Object)url, (Object)req.getQueryString());
        try {
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
        }
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }

    public static String getCallId() {
        return MDC.get((String)callIdKey);
    }
}

