/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class ExportWordUtil {
    public void replaceInPara(XWPFDocument doc, Map<String, Object> params) {
        Iterator iterator = doc.getParagraphsIterator();
        while (iterator.hasNext()) {
            XWPFParagraph para = (XWPFParagraph)iterator.next();
            this.replaceInPara(para, params);
        }
    }

    public void replaceInPara(XWPFParagraph para, Map<String, Object> params) {
        if (this.matcher(para.getParagraphText()).find()) {
            int i;
            List runs = para.getRuns();
            int start = -1;
            int end = -1;
            String str = "";
            for (i = 0; i < runs.size(); ++i) {
                XWPFRun run = (XWPFRun)runs.get(i);
                String runText = run.toString();
                System.out.println("------>>>>>>>>>" + runText);
                if ('$' == runText.charAt(0) && '{' == runText.charAt(1)) {
                    start = i;
                }
                if (start != -1) {
                    str = str + runText;
                }
                if ('}' != runText.charAt(runText.length() - 1) || start == -1) continue;
                end = i;
                break;
            }
            System.out.println("start--->" + start);
            System.out.println("end--->" + end);
            System.out.println("str---->>>" + str);
            for (i = start; i <= end; --end, ++i) {
                para.removeRun(i);
                System.out.println("remove i=" + --i);
            }
            for (String key : params.keySet()) {
                if (!str.equals(key)) continue;
                para.createRun().setText((String)params.get(key));
                break;
            }
        }
    }

    public void replaceInTable(XWPFDocument doc, Map<String, Object> params) {
        Iterator iterator = doc.getTablesIterator();
        while (iterator.hasNext()) {
            XWPFTable table = (XWPFTable)iterator.next();
            List rows = table.getRows();
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                for (XWPFTableCell cell : cells) {
                    List paras = cell.getParagraphs();
                    for (XWPFParagraph para : paras) {
                        this.replaceInPara(para, params);
                    }
                }
            }
        }
    }

    private Matcher matcher(String str) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}", 2);
        Matcher matcher = pattern.matcher(str);
        return matcher;
    }

    public void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

