/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util.aliyun;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.BucketInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALiYunFileUtil {
    private static Logger logger = LoggerFactory.getLogger(ALiYunFileUtil.class);
    private String endpoint = "";
    private String accessKeyId = "";
    private String accessKeySecret = "";
    private String bucketName = "";

    public String saveFile(String filePath, String fileName, byte[] buf) {
        fileName = this.getFileName(fileName);
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        if (ossClient.doesBucketExist(this.bucketName)) {
            logger.info("\u60a8\u5df2\u7ecf\u521b\u5efaBucket\uff1a" + this.bucketName + "\u3002");
        } else {
            logger.info("\u60a8\u7684Bucket\u4e0d\u5b58\u5728\uff0c\u521b\u5efaBucket\uff1a" + this.bucketName + "\u3002");
            ossClient.createBucket(this.bucketName);
        }
        BucketInfo info = ossClient.getBucketInfo(this.bucketName);
        logger.info("Bucket " + this.bucketName + "\u7684\u4fe1\u606f\u5982\u4e0b\uff1a");
        logger.info("\t\u6570\u636e\u4e2d\u5fc3\uff1a" + info.getBucket().getLocation());
        logger.info("\t\u521b\u5efa\u65f6\u95f4\uff1a" + info.getBucket().getCreationDate());
        logger.info("\t\u7528\u6237\u6807\u5fd7\uff1a" + info.getBucket().getOwner());
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        ossClient.putObject(this.bucketName, filePath + fileName, (InputStream)is);
        return this.endpoint + "/" + filePath + fileName;
    }

    private String getFileName(String fileName) {
        try {
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            return System.currentTimeMillis() + "." + suffix;
        }
        catch (Exception e) {
            return System.currentTimeMillis() + ".png";
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }
}

