/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ListUtils {
    public static final <T extends Comparable<T>, D> Map<T, List<D>> group(Collection<D> colls, GroupBy<T> gb) {
        if (colls == null || colls.isEmpty()) {
            return null;
        }
        if (gb == null) {
            return null;
        }
        Iterator<D> iter = colls.iterator();
        HashMap map = new HashMap();
        while (iter.hasNext()) {
            D d = iter.next();
            Comparable t = (Comparable)gb.groupby(d);
            if (map.containsKey(t)) {
                ((List)map.get(t)).add(d);
                continue;
            }
            ArrayList<D> list = new ArrayList<D>();
            list.add(d);
            map.put(t, list);
        }
        return map;
    }

    public static <K, V> void listGroup2Map(List<V> list, Map<K, List<V>> map, Class<V> clazz, String methodName) {
        if (null == list || null == map || null == clazz || null == methodName) {
            System.out.print("CommonUtils.listGroup2Map \u5165\u53c2\u9519\u8bef\uff0clist\uff1a" + list + " \uff1bmap\uff1a" + map + " \uff1bclazz\uff1a" + clazz + " \uff1bmethodName\uff1a" + methodName);
            return;
        }
        Method method = ListUtils.getMethodByName(clazz, methodName);
        if (null == method) {
            return;
        }
        ListUtils.listGroup2Map(list, map, method);
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) {
        Method method = null;
        if (null == clazz || null == methodName) {
            System.out.print("CommonUtils.getMethodByName \u5165\u53c2\u9519\u8bef\uff0cclazz\uff1a" + clazz + " \uff1bmethodName\uff1a" + methodName);
            return method;
        }
        try {
            method = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            System.out.print("\u7c7b\u83b7\u53d6\u65b9\u6cd5\u5931\u8d25\uff01");
        }
        return method;
    }

    public static <K, V> void listGroup2Map(List<V> list, Map<K, List<V>> map, Method method) {
        if (null == list || null == map || null == method) {
            System.out.print("CommonUtils.listGroup2Map \u5165\u53c2\u9519\u8bef\uff0clist\uff1a" + list + " \uff1bmap\uff1a" + map + " \uff1bmethod\uff1a" + method);
            return;
        }
        try {
            for (V val : list) {
                Object key = method.invoke(val, new Object[0]);
                List<V> listTmp = map.get(key);
                if (null == listTmp) {
                    listTmp = new ArrayList<V>();
                    map.put(key, listTmp);
                }
                listTmp.add(val);
            }
        }
        catch (Exception e) {
            System.out.print("\u5206\u7ec4\u5931\u8d25\uff01");
        }
    }

    public static interface GroupBy<T> {
        public T groupby(Object var1);
    }
}

