/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util;

import com.ailikes.util.string.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final DateTime START = DateTime.parse((String)"2014-01-01");
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static void main(String[] args) {
        Date date = new Date();
        System.out.print(DateUtil.str2Date("2014-01-01"));
    }

    public static Date str2Date(String str, String pattern) {
        try {
            DateTime dt = DateTime.parse((String)str, (DateTimeFormatter)DateTimeFormat.forPattern((String)pattern));
            return dt.toDate();
        }
        catch (Exception e) {
            logger.error("Failed parse to Date type, string is " + str, (Throwable)e);
            return null;
        }
    }

    public static Date str2Date(String str) {
        return DateUtil.str2Date(str, DATE_PATTERN);
    }

    public static Date str2Datetime(String str) {
        return DateUtil.str2Date(str, DATETIME_PATTERN);
    }

    public static Date buildMinOfDate(Date d) {
        DateTime time = new DateTime((Object)d);
        return time.millisOfDay().withMinimumValue().toDate();
    }

    public static Date buildMaxOfDate(Date d) {
        DateTime time = new DateTime((Object)d);
        return time.millisOfDay().withMaximumValue().toDate();
    }

    public static String getTodayByFormat(String format) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String szSBDate = sdf.format(c.getTime());
        return szSBDate;
    }

    public static Date getDateFromString(String dateStr) {
        Date date = new Date();
        if (StringUtil.isNotBlank(dateStr)) {
            SimpleDateFormat format = new SimpleDateFormat(DATETIME_PATTERN);
            try {
                date = format.parse(dateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return date;
    }

    public static String date2String(Date dateStr) {
        if (null != dateStr) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74-MM\u6708-dd\u65e5");
            try {
                return format.format(dateStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String dateToString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(DATETIME_PATTERN);
        if (null == date) {
            date = new Date();
        }
        String str = format.format(date);
        return str;
    }

    public static String getCurrentYearMonth() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        return String.valueOf("" + year + month);
    }
}

