/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class CaptchaUtils {
    public static final String FONT_FAMILY = "Arial Black";
    public static final Integer FONT_SIZE = 16;
    public static final String JRPT_CAPTCHA = "jrpt_captcha";

    public static String getCaptcha(int width, int height, int num, OutputStream out) {
        width = width > 0 ? width : 60;
        height = height > 0 ? height : 18;
        BufferedImage image = new BufferedImage(width, height, 1);
        Font font = new Font(FONT_FAMILY, 0, FONT_SIZE);
        Random random = new Random();
        Graphics g = image.getGraphics();
        g.setColor(CaptchaUtils.getRandColor(200, 250));
        g.fillRect(1, 1, width - 1, height - 1);
        g.setColor(new Color(102, 102, 103));
        g.drawRect(0, 0, width - 1, height - 1);
        g.setFont(font);
        g.setColor(CaptchaUtils.getRandColor(160, 200));
        for (int i = 0; i < 155; ++i) {
            int x = random.nextInt(width - 1);
            int y = random.nextInt(height - 1);
            int x1 = random.nextInt(6) + 1;
            int y1 = random.nextInt(12) + 1;
            g.drawLine(x, y, x + x1, y + y1);
        }
        String sRand = "";
        for (int i = 0; i < num; ++i) {
            String tmp = CaptchaUtils.getRandomChar();
            sRand = sRand + tmp;
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.drawString(tmp, FONT_SIZE * i + 5, FONT_SIZE + 5);
        }
        g.dispose();
        try {
            ImageIO.write((RenderedImage)image, "JPEG", out);
            out.close();
        }
        catch (IOException e) {
            sRand = null;
            e.printStackTrace();
        }
        return sRand;
    }

    public static Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    public static String getRandomChar() {
        int rand = (int)Math.round(Math.random() * 2.0);
        long itmp = 0L;
        char ctmp = '\u0000';
        switch (rand) {
            case 1: {
                itmp = Math.round(Math.random() * 25.0 + 65.0);
                ctmp = (char)itmp;
                return String.valueOf(ctmp);
            }
            case 2: {
                itmp = Math.round(Math.random() * 25.0 + 97.0);
                ctmp = (char)itmp;
                return String.valueOf(ctmp);
            }
        }
        itmp = Math.round(Math.random() * 9.0);
        return String.valueOf(itmp);
    }

    public static String getRandmonNum() {
        String s = "";
        int intCount = 0;
        intCount = new Random().nextInt(9999);
        if (intCount < 1000) {
            intCount += 1000;
        }
        s = intCount + "";
        return s;
    }
}

