/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.common.log.service.impl;

import com.junxin.common.log.entity.SystemLogEntity;
import com.junxin.common.log.service.SystemLogService;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class SystemLogServiceImpl
implements SystemLogService {
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private String tableName = "JX_SYSTEM_LOG";

    public SystemLogServiceImpl() {
        if (null == this.jdbcTemplate) {
            this.jdbcTemplate = new JdbcTemplate();
        }
        this.jdbcTemplate.setDataSource(this.dataSource);
        if (!this.validateTableNameExist()) {
            this.createTable();
        }
    }

    public SystemLogServiceImpl(DataSource dataSource) {
        if (null == this.jdbcTemplate) {
            this.jdbcTemplate = new JdbcTemplate();
        }
        this.jdbcTemplate.setDataSource(dataSource);
        if (!this.validateTableNameExist()) {
            this.createTable();
        }
    }

    public void init(DataSource dataSource) {
        if (null == this.jdbcTemplate) {
            this.jdbcTemplate = new JdbcTemplate();
        }
        this.jdbcTemplate.setDataSource(dataSource);
    }

    public boolean validateTableNameExist() {
        int tableNum = (Integer)this.jdbcTemplate.queryForObject("SELECT COUNT(*) FROM ALL_TABLES WHERE TABLE_NAME= '" + this.tableName + "'", Integer.class);
        return tableNum > 0;
    }

    public int createTable() {
        try {
            this.jdbcTemplate.update(this.genCeateTableSql());
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void saveLog(SystemLogEntity systemLog) {
        String sql = "select count(*) from " + this.tableName;
        Long num = (long)((Long)this.jdbcTemplate.queryForObject(sql, Long.class));
        System.out.println(num);
        System.out.println(systemLog.toString());
    }

    @Override
    public void saveLog(DataSource dataSource, SystemLogEntity systemLog) {
        this.init(dataSource);
        this.saveLog(systemLog);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private String genCeateTableSql() {
        StringBuffer sb = new StringBuffer("");
        sb.append("CREATE TABLE " + this.tableName + " (");
        sb.append("id varchar(36) NOT NULL primary key,");
        sb.append("user_id varchar(255) DEFAULT '',");
        sb.append("user_name varchar(255) DEFAULT '',");
        sb.append("user_type varchar(255) DEFAULT '',");
        sb.append("user_org varchar(255) DEFAULT '',");
        sb.append("module varchar(255) DEFAULT '',");
        sb.append("method varchar(255) DEFAULT '',");
        sb.append("response_time varchar(255) DEFAULT '',");
        sb.append("ip varchar(255) DEFAULT '',");
        sb.append("create_time varchar(255) DEFAULT '',");
        sb.append("commit varchar(255) DEFAULT '',");
        sb.append(")");
        return sb.toString();
    }
}

