package com.junxin.common.log.service.impl;

import java.util.Map;
import java.util.Set;
import java.util.UUID;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;

import com.junxin.common.log.entity.SystemLogEntity;
import com.junxin.common.log.service.SystemLogService;
import com.junxin.common.log.util.ObjectUtil;

/**
 * 
 * 功能描述: 日志数据库操作类,需要依赖DataSource
 * 
 * @version 1.0.0
 * @since 1.0.0
 * @author ailikes Date: 2018年7月20日 下午3:50:52
 */
public class SystemLogServiceImpl implements SystemLogService {

    private DataSource   dataSource;

    private JdbcTemplate jdbcTemplate;

    private String       tableName = "JX_SYSTEM_LOG";

    /**
     * 
     * 功能描述: 无参构造,通过get/set方法注入DataSource
     * 
     * @version 1.0.0
     * @since 1.0.0
     * @author ailikes Date: 2018年7月20日 下午3:50:52
     */
    public SystemLogServiceImpl() {
        if (null == jdbcTemplate) {
            jdbcTemplate = new JdbcTemplate();
        }
        // 这里也可以使用构造方法
        jdbcTemplate.setDataSource(dataSource);
        //判断表如果不存在,则创建一个
        if (!validateTableNameExist()) {
            createTable();
        }
    }

    /**
     * 
     * 功能描述: 通过构造方法注入DataSource
     * 
     * @version 1.0.0
     * @since 1.0.0
     * @author ailikes Date: 2018年7月20日 下午3:50:52
     */
    public SystemLogServiceImpl(DataSource dataSource) {
        if (null == jdbcTemplate) {
            jdbcTemplate = new JdbcTemplate();
        }
        // 这里也可以使用构造方法
        jdbcTemplate.setDataSource(dataSource);
        //判断表如果不存在,则创建一个
        if (!validateTableNameExist()) {
            createTable();
        }
    }

    /**
     * 
     * 功能描述: 注入DataSource
     * 
     * @param dataSource 
     * void 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author ailikes 
     * Date:   2018年7月20日 下午6:01:41
     */
    public void init(DataSource dataSource) {
        if (null == jdbcTemplate) {
            jdbcTemplate = new JdbcTemplate();
        }
        // 这里也可以使用构造方法
        jdbcTemplate.setDataSource(dataSource);
    }

    /**
     * 
     * 功能描述:验证表是否存在
     * 
     * @return boolean true存在,false不存在
     * @version 1.0.0
     * @since 1.0.0
     * @author ailikes Date: 2018年7月20日 下午5:43:05
     */
    public boolean validateTableNameExist() {
        int tableNum = (int) jdbcTemplate.queryForObject("SELECT COUNT(*) FROM ALL_TABLES WHERE TABLE_NAME= '" + tableName + "'", Integer.class);
        if (tableNum > 0) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 
     * 功能描述: 根据表名称创建一张表
     * 
     * @return  int  创建结果
     * @version 1.0.0 
     * @since 1.0.0 
     * @author ailikes 
     * Date:   2018年7月20日 下午6:02:20
     */
    public int createTable() {
        try {
            jdbcTemplate.update(genCeateTableSql());
            return 1;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public void saveLog(SystemLogEntity systemLog) {
        // sql语句
        String sql = "select count(*) from " + tableName;
        Long num = (long) jdbcTemplate.queryForObject(sql, Long.class);
        System.out.println(num);
        System.out.println(systemLog.toString());
    }

    @Override
    public void saveLog(DataSource dataSource,
                        SystemLogEntity systemLog) {
        init(dataSource);
        saveLog(systemLog);
    }

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getTableName() {

        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
    /**
     * 
     * 功能描述: 组装建表sql
     * 
     * @return 
     * String 
     * @version 1.0.0 
     * @since 1.0.0 
     * @author ailikes 
     * Date:   2018年7月21日 上午11:21:20
     */
    private String genCeateTableSql() {
        StringBuffer sb = new StringBuffer("");
        sb.append("CREATE TABLE " + tableName + " (");
        sb.append("id varchar(36) NOT NULL primary key,");
        sb.append("user_id varchar(255) DEFAULT '',");
        sb.append("user_name varchar(255) DEFAULT '',");
        sb.append("user_type varchar(255) DEFAULT '',");
        sb.append("user_org varchar(255) DEFAULT '',");
        sb.append("module varchar(255) DEFAULT '',");
        sb.append("method varchar(255) DEFAULT '',");
        sb.append("response_time varchar(255) DEFAULT '',");
        sb.append("ip varchar(255) DEFAULT '',");
        sb.append("create_time varchar(255) DEFAULT '',");
        sb.append("commit varchar(255) DEFAULT '',");
        sb.append(")");
        return sb.toString();
    }

}
