package com.junxin.common.log.util;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;  
/**
 * 
 * 功能描述: 对象操纵工具类
 * 
 * @version 1.0.0
 * @since 1.0.0 
 * @author ailikes
 * Date:   2018年7月20日 下午5:48:15
 */
public class ObjectUtil {     
    /**
     * 
     * 功能描述: 返回一个对象的属性和属性值 
     * 
     * @param entityName 实体对象
     * @return  属性MAP
     * @version 1.0.0 
     * @since 1.0.0 
     * @author ailikes 
     * Date:   2018年7月20日 下午5:59:50
     */
    @SuppressWarnings("unchecked")     
    public static Map<String,String> getProperty(Object entityName) {   
        Map<String,String> map = new HashMap<String, String>();  
        try {  
            Class c = entityName.getClass();  
            // 获得对象属性  
            Field field[] = c.getDeclaredFields();     
            for (Field f : field) {     
                Object v = invokeMethod(entityName, f.getName(), null);  
                map.put(f.getName(), v.toString());  
            }  
        } catch (Exception e) {  
            map = null;  
        }  
        return map;  
    }  
    /**
     * 
     * 功能描述: 获得对象属性的值 
     * 
     * @param owner 对象
     * @param methodName 方法名
     * @param args 参数
     * @return
     * @throws Exception 
     * Object 对象
     * @version 1.0.0 
     * @since 1.0.0 
     * @author ailikes 
     * Date:   2018年7月20日 下午5:59:09
     */
    @SuppressWarnings("unchecked")  
    private static Object invokeMethod(Object owner, String methodName,  
            Object[] args) throws Exception {  
        Class ownerClass = owner.getClass();  
        methodName = methodName.substring(0, 1).toUpperCase()  
                + methodName.substring(1);  
        Method method = null;  
        try {  
            method = ownerClass.getMethod("get" + methodName);  
        } catch (SecurityException e) {  
        } catch (NoSuchMethodException e) {  
            return " can't find 'get" + methodName + "' method";  
        }  
        return method.invoke(owner);  
    }     
}