package com.junxin.common.log.util;

import javax.servlet.http.HttpServletRequest;
/**
 * 
 * 功能描述: IP地址工具类
 * 
 * @version 1.0.0
 * @since 1.0.0 
 * @author ailikes
 * Date:   2018年7月20日 下午3:55:23
 */
public class IpUtils {
    
    /**
     * 
     * 功能描述: 根据HttpServletRequest获取客户端IP地址
     * 
     * @param request 请求
     * @return  String IP地址
     * @version 1.0.0 
     * @since 1.0.0 
     * @author ailikes 
     * Date:   2018年7月20日 下午3:55:43
     */
	public static String getIpAddr(HttpServletRequest request) {
		if (request == null) {
			return "unknown";
		}
		String ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("X-Forwarded-For");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("X-Real-IP");
		}

		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		return ip;
	}
}
