/*
 * Decompiled with CFR 0.152.
 */
package com.junxin.common.log.interceptor;

import com.junxin.common.log.annotation.SystemLog;
import com.junxin.common.log.entity.SystemLogEntity;
import com.junxin.common.log.service.SystemLogService;
import com.junxin.common.log.service.impl.SystemLogServiceImpl;
import com.junxin.common.log.util.IpUtils;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SystemLogInterceptor {
    private SystemLogService systemLogService;
    private DataSource dataSource;

    @Pointcut(value="execution(* com.junxin.modules.controller..*.*(..))")
    private void controllerAspect() {
    }

    @Around(value="controllerAspect()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        SystemLogEntity log = new SystemLogEntity();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String name = (String)request.getSession().getAttribute("USER_ID");
        log.setUserId(name);
        String time = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss").format(new Date());
        log.setDate(time);
        String ip = IpUtils.getIpAddr(request);
        log.setIp(ip);
        long start = System.currentTimeMillis();
        Object target = pjp.getTarget();
        String methodName = pjp.getSignature().getName();
        Object[] args = pjp.getArgs();
        Signature sig = pjp.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        msig = (MethodSignature)sig;
        Class<?>[] parameterTypes = msig.getMethod().getParameterTypes();
        Object object = null;
        Method method = null;
        try {
            method = target.getClass().getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        if (null != method) {
            if (method.isAnnotationPresent(SystemLog.class)) {
                SystemLog systemlog = method.getAnnotation(SystemLog.class);
                log.setModule(systemlog.module());
                log.setMethod(systemlog.method());
                if (null == this.systemLogService) {
                    this.systemLogService = new SystemLogServiceImpl(this.dataSource);
                }
                try {
                    object = pjp.proceed();
                    long end = System.currentTimeMillis();
                    log.setResponseTime("" + (end - start));
                    log.setCommit("\u6267\u884c\u6210\u529f\uff01");
                    this.systemLogService.saveLog(log);
                }
                catch (Throwable e) {
                    long end = System.currentTimeMillis();
                    log.setResponseTime("" + (end - start));
                    log.setCommit("\u6267\u884c\u5931\u8d25");
                    this.systemLogService.saveLog(log);
                }
            } else {
                object = pjp.proceed();
            }
        } else {
            object = pjp.proceed();
        }
        return object;
    }

    public SystemLogService getSystemLogService() {
        return this.systemLogService;
    }

    public void setSystemLogService(SystemLogService systemLogService) {
        this.systemLogService = systemLogService;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

