package com.junxin.common.log.service.impl;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

import com.junxin.common.log.entity.SystemLogEntity;
import com.junxin.common.log.service.SystemLogService;
/**
 * 
 * 功能描述: 日志数据库操作类,需要依赖DataSource
 * 
 * @version 1.0.0
 * @since 1.0.0 
 * @author ailikes
 * Date:   2018年7月20日 下午3:50:52
 */
public class SystemLogServiceImpl implements SystemLogService{
    
    private  DataSource dataSource;
    
    private  JdbcTemplate jdbcTemplate;
    /**
     * 
     * 功能描述: 无参构造,通过get/set方法注入DataSource
     * 
     * @version 1.0.0
     * @since 1.0.0 
     * @author ailikes
     * Date:   2018年7月20日 下午3:50:52
     */
    public SystemLogServiceImpl() {
        if(null == jdbcTemplate) {
            jdbcTemplate = new JdbcTemplate();
        }
        // 这里也可以使用构造方法
        jdbcTemplate.setDataSource(dataSource);
    }
    /**
     * 
     * 功能描述: 通过构造方法注入DataSource
     * 
     * @version 1.0.0
     * @since 1.0.0 
     * @author ailikes
     * Date:   2018年7月20日 下午3:50:52
     */
    public SystemLogServiceImpl(DataSource dataSource) {
        if(null == jdbcTemplate) {
            jdbcTemplate = new JdbcTemplate();
        }
        // 这里也可以使用构造方法
        jdbcTemplate.setDataSource(dataSource);
    }
    /**
     * 
     * 功能描述: 通过构造方法注入DataSource
     * 
     * @version 1.0.0
     * @since 1.0.0 
     * @author ailikes
     * Date:   2018年7月20日 下午3:50:52
     */
    public void init(DataSource dataSource) {
        if(null == jdbcTemplate) {
            jdbcTemplate = new JdbcTemplate();
        }
        // 这里也可以使用构造方法
        jdbcTemplate.setDataSource(dataSource);
    }
    
    @Override
    public void saveLog(SystemLogEntity systemLog) {
        // sql语句
        String sql = "select count(*) from APP_T_VERSION";
        Long num = (long) jdbcTemplate.queryForObject(sql, Long.class);
        System.out.println(num);
        System.out.println(systemLog.toString());
    }
    
    @Override
    public void saveLog(DataSource dataSource,SystemLogEntity systemLog) {
        init(dataSource);
        saveLog(systemLog);
    }

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DriverManagerDataSource dataSource) {
        this.dataSource = dataSource;
    }
    
}
