/*
 * Decompiled with CFR 0.152.
 */
package com.bocnet.common.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public class PKCS7Tool {
    private static final int SIGNER = 1;
    private static final int VERIFIER = 2;
    private int mode = 0;
    private static String digestAlgorithm = "SHA1";
    private static String signingAlgorithm = "SHA1withRSA";
    private X509Certificate[] certificates = null;
    private PrivateKey privateKey = null;
    private Certificate[] rootCertificates = null;
    private static char jvm = '\u0000';
    private static Class algorithmId = null;
    private static Class derValue = null;
    private static Class objectIdentifier = null;
    private static Class x500Name = null;
    private static boolean debug = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    private PKCS7Tool(int mode) {
        this.mode = mode;
    }

    public static PKCS7Tool getSigner(String keyStorePath, String keyStorePassword, String keyPassword) throws GeneralSecurityException, IOException {
        String type;
        if (keyStorePath.toLowerCase().endsWith(".pfx")) {
            type = "PKCS12";
        } else if (keyStorePath.toLowerCase().endsWith(".jks")) {
            type = "JKS";
        } else {
            throw new IllegalStateException("Unknown keystore type.");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(keyStorePath);
            PKCS7Tool pKCS7Tool = PKCS7Tool.getSigner(fis, type, keyStorePassword, keyPassword);
            return pKCS7Tool;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static PKCS7Tool getSigner(byte[] keyStore, String type, String keyStorePassword, String keyPassword) throws GeneralSecurityException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(keyStore);
        return PKCS7Tool.getSigner(bis, type, keyStorePassword, keyPassword);
    }

    public static PKCS7Tool getSigner(InputStream keyStoreStream, String type, String keyStorePassword, String keyPassword) throws GeneralSecurityException, IOException {
        PKCS7Tool.init();
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(keyStoreStream, keyStorePassword.toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        String keyAlias = null;
        if (aliases != null) {
            while (aliases.hasMoreElements()) {
                X509Certificate cert;
                keyAlias = aliases.nextElement();
                Certificate[] certs = keyStore.getCertificateChain(keyAlias);
                if (certs == null || certs.length == 0 || !PKCS7Tool.matchUsage((cert = (X509Certificate)certs[0]).getKeyUsage(), 1)) continue;
                try {
                    cert.checkValidity();
                    break;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
        }
        if (keyAlias == null) {
            throw new GeneralSecurityException("None certificate for sign in this keystore");
        }
        if (debug) {
            System.out.println(keyAlias);
            System.out.println("SIGNER =\n" + new BASE64Encoder().encode(keyStore.getCertificate(keyAlias).getEncoded()));
        }
        X509Certificate certificate = null;
        if (!keyStore.isKeyEntry(keyAlias) && !keyStore.isCertificateEntry(keyAlias)) {
            throw new GeneralSecurityException(String.valueOf(keyAlias) + " is unknown to this keystore");
        }
        certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
        if (privateKey == null) {
            throw new GeneralSecurityException(String.valueOf(keyAlias) + " could not be accessed");
        }
        PKCS7Tool tool = new PKCS7Tool(1);
        tool.certificates = new X509Certificate[]{certificate};
        tool.privateKey = privateKey;
        return tool;
    }

    public static PKCS7Tool getVerifier(String rootCertificatePath) throws GeneralSecurityException, IOException {
        String type;
        if (rootCertificatePath.toLowerCase().endsWith(".p7b")) {
            type = "PKCS7";
        } else if (rootCertificatePath.toLowerCase().endsWith(".cer")) {
            type = "DER";
        } else {
            throw new IllegalStateException("Unknown rootstore type.");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(rootCertificatePath);
            PKCS7Tool pKCS7Tool = PKCS7Tool.getVerifier(fis, type);
            return pKCS7Tool;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static PKCS7Tool getVerifier(byte[] rootCert, String type) throws GeneralSecurityException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(rootCert);
        return PKCS7Tool.getVerifier(bis, type);
    }

    public static PKCS7Tool getVerifier(InputStream rootCertStream, String type) throws GeneralSecurityException, IOException {
        PKCS7Tool.init();
        Certificate[] rootCertificates = null;
        CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
        if ("DER".equals(type)) {
            try {
                rootCertificates = new Certificate[]{certificatefactory.generateCertificate(rootCertStream)};
            }
            catch (Exception exception) {
                if (debug) {
                    exception.printStackTrace();
                }
                ByteArrayInputStream is = new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(rootCertStream));
                rootCertificates = new Certificate[]{certificatefactory.generateCertificate(is)};
            }
        } else if ("PKCS7".equals(type)) {
            PKCS7 p7;
            byte[] roots = PKCS7Tool.readData(rootCertStream);
            try {
                p7 = new PKCS7(roots);
            }
            catch (Exception exception) {
                roots = new BASE64Decoder().decodeBuffer(new String(roots));
                p7 = new PKCS7(roots);
            }
            rootCertificates = p7.getCertificates();
        } else {
            throw new IllegalStateException("Unknown root certificate(s) type.");
        }
        PKCS7Tool tool = new PKCS7Tool(2);
        tool.rootCertificates = rootCertificates;
        return tool;
    }

    public String sign(byte[] data) throws Exception {
        if (this.mode != 1) {
            throw new IllegalStateException("call a PKCS7Tool instance not for signature.");
        }
        Signature signer = Signature.getInstance(signingAlgorithm);
        signer.initSign(this.privateKey);
        signer.update(data, 0, data.length);
        byte[] signedAttributes = signer.sign();
        ContentInfo contentInfo = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sun.security.pkcs.ContentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field data_oidField = clazz.getField("DATA_OID");
        Object data_oid = data_oidField.get(null);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("sun.security.pkcs.ContentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Constructor<?> contentInfoConstructor = clazz2.getConstructor(data_oid.getClass(), derValue);
        Object[] objectArray = new Object[2];
        objectArray[0] = data_oid;
        contentInfo = (ContentInfo)contentInfoConstructor.newInstance(objectArray);
        X509Certificate x509 = this.certificates[this.certificates.length - 1];
        BigInteger serial = x509.getSerialNumber();
        Class[] classArray = new Class[1];
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz3;
        Constructor x500NameConstructor = x500Name.getConstructor(classArray);
        Object x500NameObject = x500NameConstructor.newInstance(x509.getIssuerDN().getName());
        Class[] classArray2 = new Class[1];
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz4;
        Method algorithmIdGet = algorithmId.getMethod("get", classArray2);
        Object digestAlgorithmId = algorithmIdGet.invoke(null, digestAlgorithm);
        Field algorithmIdfield = algorithmId.getField("RSAEncryption_oid");
        Object rsaOid = algorithmIdfield.get(null);
        Constructor algorithmConstructor = algorithmId.getConstructor(objectIdentifier);
        Object algorithmRsaOid = algorithmConstructor.newInstance(rsaOid);
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("sun.security.pkcs.SignerInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class[] classArray3 = new Class[7];
        classArray3[0] = x500Name;
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[1] = clazz6;
        classArray3[2] = algorithmId;
        Class<?> clazz7 = class$4;
        if (clazz7 == null) {
            try {
                clazz7 = class$4 = Class.forName("sun.security.pkcs.PKCS9Attributes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[3] = clazz7;
        classArray3[4] = algorithmId;
        Class<?> clazz8 = class$5;
        if (clazz8 == null) {
            try {
                clazz8 = class$5 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[5] = clazz8;
        Class<?> clazz9 = class$4;
        if (clazz9 == null) {
            try {
                clazz9 = class$4 = Class.forName("sun.security.pkcs.PKCS9Attributes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[6] = clazz9;
        Constructor<?> signerInfoConstructor = clazz5.getConstructor(classArray3);
        Object[] objectArray2 = new Object[7];
        objectArray2[0] = x500NameObject;
        objectArray2[1] = serial;
        objectArray2[2] = digestAlgorithmId;
        objectArray2[4] = algorithmRsaOid;
        objectArray2[5] = signedAttributes;
        SignerInfo si = (SignerInfo)signerInfoConstructor.newInstance(objectArray2);
        SignerInfo[] signerInfos = new SignerInfo[]{si};
        Object digestAlgorithmIds = Array.newInstance(algorithmId, 1);
        Array.set(digestAlgorithmIds, 0, digestAlgorithmId);
        Class<?> clazz10 = class$6;
        if (clazz10 == null) {
            try {
                clazz10 = class$6 = Class.forName("sun.security.pkcs.PKCS7");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class[] classArray4 = new Class[4];
        classArray4[0] = digestAlgorithmIds.getClass();
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("sun.security.pkcs.ContentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray4[1] = clazz11;
        Class<?> clazz12 = class$7;
        if (clazz12 == null) {
            try {
                clazz12 = class$7 = Class.forName("[Ljava.security.cert.X509Certificate;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray4[2] = clazz12;
        classArray4[3] = signerInfos.getClass();
        Constructor<?> pkcs7Constructor = clazz10.getConstructor(classArray4);
        PKCS7 p7 = (PKCS7)pkcs7Constructor.newInstance(digestAlgorithmIds, contentInfo, this.certificates, signerInfos);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        p7.encodeSignedData(baout);
        return new BASE64Encoder().encode(baout.toByteArray());
    }

    public void verify(String signature, byte[] data, String dn) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, CertificateException, NoSuchProviderException {
        SignerInfo[] sis;
        if (this.mode != 2) {
            throw new IllegalStateException("call a PKCS7Tool instance not for verify.");
        }
        byte[] sign = new BASE64Decoder().decodeBuffer(signature);
        PKCS7 p7 = new PKCS7(sign);
        X509Certificate[] certs = p7.getCertificates();
        if (debug) {
            int i = 0;
            while (i < certs.length) {
                X509Certificate cert = certs[i];
                System.out.println("SIGNER " + i + "=\n" + cert);
                System.out.println("SIGNER " + i + "=\n" + new BASE64Encoder().encode(cert.getEncoded()));
                ++i;
            }
        }
        if ((sis = p7.verify(data)) == null) {
            throw new SignatureException("Signature failed verification, data has been tampered");
        }
        int i = 0;
        while (i < sis.length) {
            X500Principal name;
            SignerInfo si = sis[i];
            X509Certificate cert = si.getCertificate(p7);
            cert.checkValidity();
            boolean valid = false;
            int j = this.rootCertificates.length - 1;
            while (j >= 0) {
                if (cert.equals(this.rootCertificates[j])) {
                    valid = true;
                    break;
                }
                try {
                    cert.verify(this.rootCertificates[j].getPublicKey());
                    valid = true;
                    break;
                }
                catch (Exception exception) {
                    --j;
                }
            }
            if (!valid) {
                throw new SignatureException("Signature certificate's issuer is untrusty.");
            }
            if (i == 0 && dn != null && !dn.equals((name = cert.getSubjectX500Principal()).getName("RFC1779")) && !new X500Principal(dn).equals(name)) {
                throw new SignatureException("Signer dn '" + name.getName("RFC1779") + "' does not matchs '" + dn + "'");
            }
            ++i;
        }
    }

    private static boolean matchUsage(boolean[] keyUsage, int usage) {
        if (usage == 0 || keyUsage == null) {
            return true;
        }
        int i = 0;
        while (i < Math.min(keyUsage.length, 32)) {
            if ((usage & 1 << i) != 0 && !keyUsage[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void init() {
        if (jvm != '\u0000') {
            return;
        }
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor == null) {
            vendor = "";
        }
        String vendorUC = vendor.toUpperCase();
        try {
            if (vendorUC.indexOf("IBM") >= 0) {
                jvm = (char)73;
                algorithmId = Class.forName("com.ibm.security.x509.AlgorithmId");
                derValue = Class.forName("com.ibm.security.util.DerValue");
                objectIdentifier = Class.forName("com.ibm.security.util.ObjectIdentifier");
                x500Name = Class.forName("com.ibm.security.x509.X500Name");
            } else {
                jvm = (char)83;
                algorithmId = Class.forName("sun.security.x509.AlgorithmId");
                derValue = Class.forName("sun.security.util.DerValue");
                objectIdentifier = Class.forName("sun.security.util.ObjectIdentifier");
                x500Name = Class.forName("sun.security.x509.X500Name");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.out.println("Not support JRE: " + vendor);
            throw new RuntimeException(e);
        }
    }

    public static final String getDigestAlgorithm() {
        return digestAlgorithm;
    }

    public static final void setDigestAlgorithm(String digestAlgorithm0) {
        digestAlgorithm = digestAlgorithm0;
    }

    public static final String getSigningAlgorithm() {
        return signingAlgorithm;
    }

    public static final void setSigningAlgorithm(String signingAlgorithm0) {
        signingAlgorithm = signingAlgorithm0;
    }

    public static void setDebug(boolean debug) {
        PKCS7Tool.debug = debug;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public Certificate[] getRootCertificates() {
        return this.rootCertificates;
    }

    protected static byte[] readData(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream bai = new ByteArrayOutputStream();
        byte[] buf = new byte[256];
        while ((len = in.read(buf)) > 0) {
            bai.write(buf, 0, len);
        }
        return bai.toByteArray();
    }
}

