/*
 * Decompiled with CFR 0.152.
 */
package com.bocnet.common.security;

import com.bocnet.common.security.PKCS7Tool;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class P7Sign {
    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 6) {
            System.out.println("Usage: \nP7Sign keystorefile keystorepassword [inputfile [outputfile]]\n\t keystorefile support .jks or .pfx file.");
            System.exit(-1);
        }
        if (args[args.length - 2].startsWith("-SHA")) {
            PKCS7Tool.setDigestAlgorithm(args[args.length - 2].substring(1));
            PKCS7Tool.setSigningAlgorithm(String.valueOf(args[args.length - 2].substring(1)) + "withRSA");
            args[args.length - 2] = null;
        }
        if ("-debug".equals(args[args.length - 1])) {
            PKCS7Tool.setDebug(true);
            args[args.length - 1] = null;
        }
        InputStream in = System.in;
        OutputStream out = System.out;
        try {
            PKCS7Tool tool = PKCS7Tool.getSigner(args[0], args[1], args[1]);
            if (args.length > 2 && args[2] != null) {
                in = new FileInputStream(args[2]);
            }
            if (args.length > 3 && args[3] != null) {
                out = new FileOutputStream(args[3]);
            }
            byte[] data = PKCS7Tool.readData(in);
            String signature = tool.sign(data);
            out.write(signature.getBytes());
            System.out.println("[SIGN OK]");
        }
        finally {
            if (in != null && System.in != in) {
                in.close();
            }
            if (out != null && System.out != out) {
                out.close();
            }
        }
    }
}

