/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ComplexPropertyPreFilter
implements PropertyPreFilter {
    private Map<Class<?>, Set<String>> includes = new HashMap();
    private Map<Class<?>, Set<String>> excludes = new HashMap();

    public ComplexPropertyPreFilter() {
    }

    public ComplexPropertyPreFilter(Map<Class<?>, Set<String>> includes) {
        this.includes = includes;
    }

    public void addIncludeFilter(Class<?> clazz, String ... properties) {
        Set<Object> includeSet = null;
        if (!this.includes.containsKey(clazz)) {
            includeSet = new HashSet();
            this.includes.put(clazz, includeSet);
        } else {
            includeSet = this.includes.get(clazz);
        }
        for (String item : properties) {
            if (item == null) continue;
            includeSet.add(item);
        }
    }

    public void addExcludeFilter(Class<?> clazz, String ... properties) {
        Set<Object> excludeSet = null;
        if (!this.excludes.containsKey(clazz)) {
            excludeSet = new HashSet();
            this.excludes.put(clazz, excludeSet);
        } else {
            excludeSet = this.excludes.get(clazz);
        }
        for (String item : properties) {
            if (item == null) continue;
            excludeSet.add(item);
        }
    }

    public boolean apply(JSONSerializer serializer, Object source, String name) {
        if (source == null) {
            return true;
        }
        Class<?> clazz = source.getClass();
        Set<String> excludeSet = this.getValue(this.excludes, clazz);
        if (excludeSet != null && excludeSet.contains(name)) {
            return false;
        }
        if (this.includes.isEmpty()) {
            return true;
        }
        Set<String> includeSet = this.getValue(this.includes, clazz);
        if (includeSet != null) {
            return includeSet.contains(name);
        }
        return true;
    }

    public Set<String> getValue(Map<Class<?>, Set<String>> clazzMaps, Class<?> clazz) {
        Set<String> value = null;
        for (Map.Entry<Class<?>, Set<String>> item : clazzMaps.entrySet()) {
            if (!item.getKey().isAssignableFrom(clazz)) continue;
            value = item.getValue();
        }
        return value;
    }

    public Map<Class<?>, Set<String>> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Map<Class<?>, Set<String>> includes) {
        this.includes = includes;
    }

    public Map<Class<?>, Set<String>> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Map<Class<?>, Set<String>> excludes) {
        this.excludes = excludes;
    }

    static {
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }
}

