/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils;

import com.ailikes.common.utils.FileUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PdfWatermarkUtils {
    public static void setWatermark(String sourcePath, String targetPath, String waterMarkName) throws IOException, DocumentException {
        PdfWatermarkUtils.setWatermark(sourcePath, targetPath, waterMarkName, 1.0f);
    }

    public static void setWatermark(String sourcePath, String targetPath, String waterMarkName, float opacity) throws IOException, DocumentException {
        byte[] bytes = FileUtil.toByteArray(sourcePath);
        FileOutputStream outPutStream = FileUtil.openOutputStream((File)new File(targetPath));
        PdfReader pr = new PdfReader(bytes, "PDF".getBytes());
        int pageSize = pr.getNumberOfPages();
        PdfStamper stam = new PdfStamper(pr, (OutputStream)outPutStream);
        PdfContentByte content = null;
        BaseFont base = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(opacity);
        for (int i = 1; i <= pageSize; ++i) {
            content = stam.getOverContent(i);
            content.setGState(gs);
            content.beginText();
            content.setColorFill(BaseColor.LIGHT_GRAY);
            content.setFontAndSize(base, 50.0f);
            content.setTextMatrix(70.0f, 200.0f);
            content.showTextAligned(1, waterMarkName, 100.0f, 750.0f, 45.0f);
            content.showTextAligned(1, waterMarkName, 250.0f, 650.0f, 45.0f);
            content.showTextAligned(1, waterMarkName, 350.0f, 550.0f, 45.0f);
            content.showTextAligned(1, waterMarkName, 200.0f, 250.0f, 45.0f);
            content.showTextAligned(1, waterMarkName, 350.0f, 150.0f, 45.0f);
            content.showTextAligned(1, waterMarkName, 500.0f, 350.0f, 45.0f);
            content.endText();
        }
        stam.close();
    }
}

