/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils;

import com.ailikes.common.utils.SpringContextHolder;
import org.springframework.context.MessageSource;

public class MessageUtils {
    private static MessageSource messageSource;

    public static String getMessage(String code, Object ... args) {
        try {
            if (messageSource == null) {
                messageSource = SpringContextHolder.getBean(MessageSource.class);
            }
            return messageSource.getMessage(code, args, null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getMessage(String code, String defaultMessage, Object ... args) {
        try {
            if (messageSource == null) {
                messageSource = SpringContextHolder.getBean(MessageSource.class);
            }
            return messageSource.getMessage(code, args, defaultMessage, null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getMessageOrSelf(String code, Object ... args) {
        String message = "";
        try {
            if (messageSource == null) {
                messageSource = SpringContextHolder.getBean(MessageSource.class);
            }
            return messageSource.getMessage(code, args, null);
        }
        catch (Exception e) {
            message = code;
            return message;
        }
    }
}

