/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils;

import com.ailikes.common.utils.Exceptions;
import com.ailikes.common.utils.FileUtils;
import com.ailikes.common.utils.ServletUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class FreeMarkerUtils {
    public static final int TEMPLATE_LOADING_FILE = 1;
    public static final int TEMPLATE_LOADING_CLASS = 2;
    public static final Locale LOCALE = Locale.US;
    public static final String ENCODING = "UTF-8";
    public static Configuration configuration = null;

    public static FreeMarkerUtils initByDefaultTemplate() {
        FreeMarkerUtils freeMarker = new FreeMarkerUtils();
        freeMarker.initConfiguration(2, "/template");
        return freeMarker;
    }

    public static FreeMarkerUtils initByClassTemplate(String templatePath) {
        FreeMarkerUtils freeMarker = new FreeMarkerUtils();
        freeMarker.initConfiguration(2, templatePath);
        return freeMarker;
    }

    public static FreeMarkerUtils initByFileTemplate(String templatePath) {
        FreeMarkerUtils freeMarker = new FreeMarkerUtils();
        freeMarker.initConfiguration(1, templatePath);
        return freeMarker;
    }

    public void initConfiguration(String templatePath) {
        this.initConfiguration(2, templatePath);
    }

    public void initConfiguration(int type, String templatePath) {
        configuration = new Configuration();
        ClassTemplateLoader templateLoader = null;
        switch (type) {
            case 1: {
                try {
                    if (!FileUtils.isAbsolutePath(templatePath)) {
                        String filePath = ServletUtils.getRequest().getSession().getServletContext().getRealPath("/");
                        templatePath = filePath + templatePath;
                    }
                    templateLoader = new FileTemplateLoader(new File(templatePath));
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case 2: {
                templateLoader = new ClassTemplateLoader(FreeMarkerUtils.class, templatePath);
            }
        }
        configuration.setTemplateLoader(templateLoader);
        configuration.setLocale(LOCALE);
        configuration.setEncoding(LOCALE, ENCODING);
    }

    public String renderString(String templateString, Map<String, ?> model) {
        try {
            StringWriter result = new StringWriter();
            Template t = new Template("name", (Reader)new StringReader(templateString), new Configuration());
            t.setEncoding(ENCODING);
            t.process(model, (Writer)result);
            return result.toString();
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public Template getTemplate(String name) {
        Template template = null;
        try {
            template = configuration.getTemplate(name);
            template.setEncoding(ENCODING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return template;
    }

    public String processToString(String name, Object rootMap) {
        StringWriter writer = new StringWriter();
        this.process(name, rootMap, (Writer)writer);
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processToFile(String name, Map<String, Object> rootMap, String outFile) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), ENCODING));
            this.process(name, rootMap, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(String name, Object rootMap, Writer writer) {
        this.process(this.getTemplate(name), rootMap, writer);
    }

    public void process(Template template, Object rootMap, Writer writer) {
        try {
            template.process(rootMap, writer);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processConsole(String name, Map<String, Object> root) {
        System.out.println(this.processToString(name, root));
    }
}

