/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils.jcaptcha;

import com.ailikes.common.utils.jcaptcha.EsManageableImageCaptchaService;
import com.ailikes.common.utils.jcaptcha.GMailEngine;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaStore;
import com.octo.captcha.service.captchastore.FastHashMapCaptchaStore;
import javax.servlet.http.HttpServletRequest;

public class JCaptcha {
    public static final EsManageableImageCaptchaService captchaService = new EsManageableImageCaptchaService((CaptchaStore)new FastHashMapCaptchaStore(), (CaptchaEngine)new GMailEngine(), 180, 100000, 75000);

    public static boolean validateResponse(HttpServletRequest request, String userCaptchaResponse) {
        if (request.getSession(false) == null) {
            return false;
        }
        boolean validated = true;
        try {
            String id = request.getSession().getId();
            validated = captchaService.validateResponseForID(id, userCaptchaResponse);
        }
        catch (CaptchaServiceException e) {
            e.printStackTrace();
        }
        return validated;
    }

    public static boolean hasCaptcha(HttpServletRequest request, String userCaptchaResponse) {
        if (request.getSession(false) == null) {
            return false;
        }
        boolean validated = false;
        try {
            String id = request.getSession().getId();
            validated = captchaService.hasCapcha(id, userCaptchaResponse);
        }
        catch (CaptchaServiceException e) {
            e.printStackTrace();
        }
        return validated;
    }
}

