/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils;

import com.ailikes.common.utils.DateUtils;
import com.ailikes.common.utils.StringUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.beans.BeanUtils;

public class MapBeanUtil {
    public static Map<String, Object> convertBean(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(bean, new Object[0]);
            if (result != null) {
                returnMap.put(propertyName, result);
                continue;
            }
            returnMap.put(propertyName, "");
        }
        return returnMap;
    }

    public static void setField(Object obj, String fieldname, Object value) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        MapBeanUtil.setField(obj, fieldname, value, value.getClass());
    }

    public static void setField(Object obj, String fieldname, Object value, Class<?> valueClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (fieldname.length() > 0 && PropertyUtils.isWriteable((Object)obj, (String)fieldname)) {
            Class valueclass = BeanUtils.findPropertyType((String)fieldname, (Class[])new Class[]{obj.getClass()});
            Object rObject = MapBeanUtil.Caster(valueclass, String.valueOf(value));
            PropertyUtils.setProperty((Object)obj, (String)fieldname, (Object)rObject);
        }
    }

    public static void setFieldEx(Object obj, String fieldName, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex > 0) {
            Method subObj = MapBeanUtil.getField(obj, fieldName.substring(0, dotIndex));
            MapBeanUtil.setFieldEx(subObj, fieldName.substring(dotIndex + 1), value);
        } else {
            MapBeanUtil.setField(obj, fieldName, value);
        }
    }

    public static Object getFieldEx(Object obj, String fieldName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex > 0) {
            Method subObj = MapBeanUtil.getField(obj, fieldName.substring(0, dotIndex));
            return MapBeanUtil.getFieldEx(subObj, fieldName.substring(dotIndex + 1));
        }
        return MapBeanUtil.getField(obj, fieldName);
    }

    public static Object Caster(Class<?> type, String value) {
        Object returnValue = null;
        if (value == null || value == "null" || "".equals(value)) {
            return null;
        }
        if (type.getName().equals("java.util.Date")) {
            returnValue = value.indexOf("Z") != -1 && value.indexOf("T") != -1 ? value : DateUtils.parseDate(value);
        } else if (type.getName().equals("java.sql.Timestamp")) {
            if (value.indexOf("Z") != -1 && value.indexOf("T") != -1) {
                value = value.replace("Z", "");
                value = value.replace("T", " ");
                Date d = DateUtils.parseDate(value);
                Timestamp t = new Timestamp(d.getTime());
                returnValue = t;
            } else {
                Date d = DateUtils.parseDate(value);
                Timestamp t = new Timestamp(d.getTime());
                returnValue = t;
            }
        } else if (type.getName().endsWith("Long")) {
            if (StringUtils.isNumericAndDot(value)) {
                returnValue = Long.valueOf(value);
            }
        } else if (type.getName().endsWith("Integer")) {
            if (StringUtils.isNumericAndDot(value)) {
                returnValue = Integer.valueOf(value);
            }
        } else if (type.getName().endsWith("int")) {
            returnValue = StringUtils.isNumericAndDot(value) ? Integer.valueOf(value) : Integer.valueOf(0);
        } else if (type.getName().endsWith("Double")) {
            if (StringUtils.isNumericAndDot(value)) {
                returnValue = Double.valueOf(value);
            }
        } else if (type.getName().endsWith("double")) {
            returnValue = StringUtils.isNumericAndDot(value) ? Double.valueOf(value) : Double.valueOf(0.0);
        } else if (type.getName().endsWith("Byte")) {
            if (StringUtils.isNumericAndDot(value)) {
                returnValue = Byte.valueOf(value);
            }
        } else {
            returnValue = type.getName().endsWith("byte") ? (StringUtils.isNumericAndDot(value) ? (Number)Byte.valueOf(value) : (Number)0) : (type.getName().endsWith("Boolean") || type.getName().endsWith("boolean") ? Boolean.valueOf(Boolean.parseBoolean(value)) : (type.getName().endsWith("bool") ? Boolean.valueOf(Boolean.parseBoolean(value)) : (type.getName().endsWith("BigDecimal") ? new BigDecimal(value) : value.toString())));
        }
        return returnValue;
    }

    public static Method getField(Object obj, String fieldname) {
        if (obj == null) {
            return null;
        }
        if (fieldname.length() > 0) {
            String methodname = "get" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1, fieldname.length());
            try {
                Method m = obj.getClass().getMethod(methodname, new Class[0]);
                return m;
            }
            catch (NoSuchMethodException e) {
                System.out.println(obj.getClass().getName() + "\u4e2d\u672a\u627e\u5230\u65b9\u6cd5 :" + methodname);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static List<String> getFiledList(Object obj) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Field[] fields;
            Class<?> clazz = obj.getClass();
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                Method getMethod = pd.getReadMethod();
                String filed = "";
                filed = getMethod.getName().toLowerCase().startsWith("is") ? getMethod.getName().substring(2) : getMethod.getName().substring(3);
                list.add(filed);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Object getFieldValue(Object obj, String fieldname) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map<String, Object> map = MapBeanUtil.extracted(obj);
            if (map.containsKey(fieldname)) {
                return map.get(fieldname);
            }
            return null;
        }
        if (fieldname.length() > 0) {
            String methodname = "get" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1, fieldname.length());
            String methodname1 = "is" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1, fieldname.length());
            try {
                Method m = obj.getClass().getMethod(methodname, new Class[0]);
                return m.invoke(obj, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method m = obj.getClass().getMethod(methodname1, new Class[0]);
                    return m.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    e1.printStackTrace();
                }
                catch (SecurityException e1) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e1) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e.printStackTrace();
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Map<String, Object> extracted(Object obj) {
        return (Map)obj;
    }

    public static void setFieldValue(Object obj, String fieldname, Object value) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (value != null) {
            MapBeanUtil.setFieldValue(obj, fieldname, value, value.getClass());
        } else {
            MapBeanUtil.setFieldValue(obj, fieldname, value, null);
        }
    }

    public static Method getMethod(Class<?> cls, String methodName) {
        if (cls == null) {
            return null;
        }
        for (Method m : cls.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public static boolean CopyFromOneToOther(Object from, Object to, String Exception2) {
        List<String> Field2 = MapBeanUtil.getFiledList(from);
        if (Exception2 == null) {
            Exception2 = "";
        }
        for (int i = 0; i < Field2.size(); ++i) {
            Object value;
            if (("," + Exception2 + ",").contains(Field2.get(i)) || (value = MapBeanUtil.getFieldValue(from, Field2.get(i))) == null) continue;
            try {
                MapBeanUtil.setFieldValue(to, Field2.get(i), value, value.getClass());
                continue;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static <T> List<T> ListDoWhere(List<T> list, String FieldName, Object Value) {
        ArrayList<T> reslist = new ArrayList<T>();
        if (list == null) {
            return reslist;
        }
        for (int i = 0; i < list.size(); ++i) {
            T obj = list.get(i);
            Object myobj = MapBeanUtil.getFieldValue(obj, FieldName);
            if (myobj == null && (myobj != null || Value != null) || !myobj.equals(Value)) continue;
            reslist.add(obj);
        }
        return reslist;
    }

    public static <T> List<Object> ListDoSelect(List<T> list, String FieldName) {
        ArrayList<Object> reslist = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            T obj = list.get(i);
            Object myobj = MapBeanUtil.getFieldValue(obj, FieldName);
            if (myobj == null) continue;
            reslist.add(myobj);
        }
        return reslist;
    }

    public static void setFieldValue(Object obj, String fieldname, Object value, Class<?> valueClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (obj == null) {
            return;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.put(fieldname, value);
        } else if (fieldname.length() > 0) {
            String methodname = "set" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1, fieldname.length());
            try {
                Method m = null;
                m = MapBeanUtil.getMethod(obj.getClass(), methodname);
                if (m != null) {
                    m.invoke(obj, value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setFieldValueEx(Object obj, String fieldName, Object value) {
        try {
            int dotIndex = fieldName.indexOf(".");
            if (dotIndex > 0) {
                Object subObj = MapBeanUtil.getFieldValue(obj, fieldName.substring(0, dotIndex));
                MapBeanUtil.setFieldValueEx(subObj, fieldName.substring(dotIndex + 1), value);
            } else {
                MapBeanUtil.setFieldValue(obj, fieldName, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValueEx(Object obj, String fieldName) {
        int dotIndex = fieldName.indexOf(".");
        try {
            if (dotIndex > 0) {
                Object subObj = MapBeanUtil.getFieldValue(obj, fieldName.substring(0, dotIndex));
                return MapBeanUtil.getFieldValueEx(subObj, fieldName.substring(dotIndex + 1));
            }
            return MapBeanUtil.getFieldValue(obj, fieldName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object json2Objec(Object obj, JSONObject json) {
        if (json == null) {
            return obj;
        }
        if (obj == null) {
            return obj;
        }
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = String.valueOf(it.next());
            try {
                Object value = json.get(key);
                if (value instanceof JSONObject || value instanceof JSONArray) continue;
                MapBeanUtil.setField(obj, key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static Object json2Objec(Object obj, JSONObject json, Boolean applyChildren) {
        if (json == null) {
            return obj;
        }
        if (obj == null) {
            return obj;
        }
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = String.valueOf(it.next());
            try {
                Object value = json.get(key);
                if (!(value instanceof JSONObject) && !(value instanceof JSONArray)) {
                    MapBeanUtil.setField(obj, key, value);
                    continue;
                }
                if (value instanceof JSONObject) {
                    Method method;
                    if (!applyChildren.booleanValue() || (method = MapBeanUtil.getField(obj, key)) == null) continue;
                    try {
                        Object newObject = method.getReturnType().newInstance();
                        if (newObject == null) continue;
                        MapBeanUtil.json2Objec(newObject, (JSONObject)value, applyChildren);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!(value instanceof JSONArray)) continue;
                JSONArray jarray = (JSONArray)value;
                for (Object jobj : jarray) {
                    Method method;
                    if (!(jobj instanceof JSONObject)) continue;
                    JSONObject jsonObj = (JSONObject)jobj;
                    if (!applyChildren.booleanValue() || (method = MapBeanUtil.getField(obj, key)) == null) continue;
                    try {
                        Object newObject = method.getReturnType().newInstance();
                        if (newObject == null) continue;
                        MapBeanUtil.json2Objec(newObject, jsonObj, applyChildren);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }
}

