/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileUtil
extends FileUtils {
    private static String matches = "[A-Za-z]:\\\\[^:?\"><*]*";
    boolean flag = false;
    File file;

    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/") || path.indexOf(":") > 0;
    }

    public boolean deleteFolder(String deletePath) {
        this.flag = false;
        if (deletePath.matches(matches)) {
            this.file = new File(deletePath);
            if (!this.file.exists()) {
                return this.flag;
            }
            if (this.file.isFile()) {
                return this.deleteFile(deletePath);
            }
            return this.deleteDirectory(deletePath);
        }
        return false;
    }

    public boolean deleteFile(String filePath) {
        this.flag = false;
        this.file = new File(filePath);
        if (this.file.isFile() && this.file.exists()) {
            this.file.delete();
            this.flag = true;
        }
        return this.flag;
    }

    public boolean deleteDirectory(String dirPath) {
        File dirFile;
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        if (!(dirFile = new File(dirPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        this.flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                this.flag = this.deleteFile(files[i].getAbsolutePath());
                if (this.flag) continue;
                break;
            }
            this.flag = this.deleteDirectory(files[i].getAbsolutePath());
            if (!this.flag) break;
        }
        if (!this.flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean createFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return false;
        }
        if (filePath.endsWith(File.separator)) {
            return false;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String createTempFile(String prefix, String suffix, String dirName) {
        File tempFile = null;
        if (dirName == null) {
            try {
                tempFile = File.createTempFile(prefix, suffix);
                return tempFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
                return null;
            }
        }
        File dir = new File(dirName);
        if (!dir.exists() && FileUtil.mkDir(dirName)) {
            System.out.println("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u4e0d\u80fd\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\uff01");
            return null;
        }
        try {
            tempFile = File.createTempFile(prefix, suffix, dir);
            return tempFile.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25!" + e.getMessage());
            return null;
        }
    }

    public static void mkFile(String filePath, boolean mkdir) throws Exception {
        File file = new File(filePath);
        file.getParentFile().mkdirs();
        file.createNewFile();
        file = null;
    }

    public static boolean mkDir(String dirPath) {
        File dir = new File(dirPath);
        if (dir.exists()) {
            System.out.println("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff0c\u76ee\u6807\u76ee\u5f55\u5df2\u5b58\u5728\uff01");
            return false;
        }
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        if (dir.mkdirs()) {
            System.out.println("\u521b\u5efa\u76ee\u5f55\u6210\u529f\uff01" + dirPath);
            return true;
        }
        System.out.println("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff01");
        return false;
    }

    public static boolean delFile(String filePath) {
        return new File(filePath).delete();
    }

    public static boolean delDir(String dirPath, boolean delFile) {
        if (delFile) {
            File file = new File(dirPath);
            if (file.isFile()) {
                return file.delete();
            }
            if (file.isDirectory()) {
                if (file.listFiles().length == 0) {
                    return file.delete();
                }
                int zfiles = file.listFiles().length;
                File[] delfile = file.listFiles();
                for (int i = 0; i < zfiles; ++i) {
                    if (delfile[i].isDirectory()) {
                        FileUtil.delDir(delfile[i].getAbsolutePath(), true);
                    }
                    delfile[i].delete();
                }
                return file.delete();
            }
            return false;
        }
        return new File(dirPath).delete();
    }

    public static void copy(String source, String target, boolean isFolder) throws Exception {
        if (isFolder) {
            new File(target).mkdirs();
            File a = new File(source);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = source.endsWith(File.separator) ? new File(source + file[i]) : new File(source + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(target + "/" + temp.getName().toString());
                    byte[] b = new byte[1024];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copy(source + "/" + file[i], target + "/" + file[i], true);
            }
        } else {
            int byteread = 0;
            File oldfile = new File(source);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(source);
                File file = new File(target);
                file.getParentFile().mkdirs();
                file.createNewFile();
                FileOutputStream fs = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
                ((InputStream)inStream).close();
                fs.close();
            }
        }
    }

    public static boolean move(String source, String target, boolean isFolder) throws Exception {
        FileUtil.copy(source, target, isFolder);
        if (isFolder) {
            return FileUtil.delDir(source, true);
        }
        return FileUtil.delFile(source);
    }

    public static byte[] toByteArray(String filePath) throws IOException {
        FileInputStream in = null;
        File file = new File(filePath);
        in = new FileInputStream(file);
        byte[] bytes = IOUtils.toByteArray((InputStream)in);
        if (in != null) {
            in.close();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + "\\" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        String dirName = "E:/createFile/";
        FileUtil.mkDir(dirName);
        String fileName = dirName + "/file1.txt";
        FileUtil.createFile(fileName);
        String prefix = "temp";
        String surfix = ".txt";
        for (int i = 0; i < 10; ++i) {
            System.out.println("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6: " + FileUtil.createTempFile(prefix, surfix, dirName));
        }
    }
}

