/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils.fastjson;

import com.ailikes.common.utils.fastjson.ComplexPropertyPreFilter;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FastjsonPropertyPreFilter
extends ComplexPropertyPreFilter {
    public FastjsonPropertyPreFilter() {
    }

    public FastjsonPropertyPreFilter(Class<?> clazz, String includesProperties) {
        this.addIncludeFilter(clazz, includesProperties);
    }

    public FastjsonPropertyPreFilter(Map<Class<?>, Set<String>> includes) {
        super(includes);
    }

    public Class<?> getSubClass(Class<?> clazz, String fieldname) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            Class<?> type = field.getType();
            if (!fieldname.equals(name)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void addIncludeFilter(Class<?> clazz, String ... properties) {
        for (String property : properties) {
            String[] propertieArr;
            if (StringUtils.isEmpty((CharSequence)(property = property.trim()))) continue;
            for (String singleProperty : propertieArr = property.split(",")) {
                if (StringUtils.isEmpty((CharSequence)(singleProperty = singleProperty.trim())) || StringUtils.isEmpty((CharSequence)singleProperty)) continue;
                this.addSingleIncludeFilter(clazz, singleProperty);
            }
        }
    }

    private void addSingleIncludeFilter(Class<?> clazz, String property) {
        if (!property.contains(".")) {
            super.addIncludeFilter(clazz, property);
        } else {
            String[] subPropertes;
            for (String subProperty : subPropertes = property.split("\\.")) {
                if (clazz == null) continue;
                super.addIncludeFilter(clazz, subProperty);
                Class<?> subClazz = this.getSubClass(clazz, subProperty);
                clazz = subClazz;
            }
        }
    }

    @Override
    public void addExcludeFilter(Class<?> clazz, String ... properties) {
        for (String property : properties) {
            String[] propertieArr;
            if (StringUtils.isEmpty((CharSequence)(property = property.trim()))) continue;
            for (String singleProperty : propertieArr = property.split(",")) {
                if (StringUtils.isEmpty((CharSequence)(singleProperty = singleProperty.trim())) || StringUtils.isEmpty((CharSequence)singleProperty)) continue;
                this.addSingleExcludeFilter(clazz, singleProperty);
            }
        }
    }

    private void addSingleExcludeFilter(Class<?> clazz, String property) {
        if (!property.contains(".")) {
            super.addExcludeFilter(clazz, property);
        } else {
            String[] subPropertes;
            for (String subProperty : subPropertes = property.split("\\.")) {
                if (clazz == null) continue;
                super.addExcludeFilter(clazz, subProperty);
                Class<?> subClazz = this.getSubClass(clazz, subProperty);
                clazz = subClazz;
            }
        }
    }
}

