/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils;

import com.ailikes.common.utils.Reflections;
import com.alibaba.fastjson.JSONObject;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final String CHARSET_NAME = "UTF-8";
    static String COMMA = ",";

    public static byte[] getBytes(String str) {
        if (str != null) {
            try {
                return str.getBytes(CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static void printJson(HttpServletResponse response, Object content) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding(CHARSET_NAME);
            PrintWriter pw = response.getWriter();
            String json = JSONObject.toJSONString((Object)content);
            pw.print(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printJson(HttpServletResponse response, String content) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding(CHARSET_NAME);
            PrintWriter pw = response.getWriter();
            pw.write(content);
            pw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String camelToStrikethrough(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('-');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String strikethroughToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String hashKeyForDisk(String key) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = StringUtils.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    public static String bytesToHexString2(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static String getFileNameNoEx(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static String randomUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

    public static String randomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String randomNumber(int length) {
        String base = "0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static boolean isNumericAndDot(String str) {
        if (str == null || str.trim().equals("")) {
            return false;
        }
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]*([Ee]{1}[0-9]+)?");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String trimFirstAndLastChar(String source, char element) {
        boolean beginIndexFlag = true;
        boolean endIndexFlag = true;
        do {
            int beginIndex = source.indexOf(element) == 0 ? 1 : 0;
            int endIndex = source.lastIndexOf(element) + 1 == source.length() ? source.lastIndexOf(element) : source.length();
            source = source.substring(beginIndex, endIndex);
            beginIndexFlag = source.indexOf(element) == 0;
            boolean bl = endIndexFlag = source.lastIndexOf(element) + 1 == source.length();
        } while (beginIndexFlag || endIndexFlag);
        return source;
    }

    public static String abbr(String str, int length) {
        if (str == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            int currentLength = 0;
            for (char c : StringUtils.replaceHtml(StringEscapeUtils.unescapeHtml4((String)str)).toCharArray()) {
                if ((currentLength += String.valueOf(c).getBytes("GBK").length) > length - 3) {
                    sb.append("...");
                    break;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String replaceHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        String regEx = "<.+?>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(html);
        String s = m.replaceAll("");
        return s;
    }

    public static <T> String toFormatterValue(List<T> datas, String label, String value) {
        String formaterValues = "";
        for (T data : datas) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formaterValues)) {
                formaterValues = formaterValues + ";";
            }
            String labelValue = Reflections.getFieldValue(data, label) + "";
            String valueValue = Reflections.getFieldValue(data, value) + "";
            String formaterValue = valueValue + ":" + labelValue;
            formaterValues = formaterValues + formaterValue;
        }
        return formaterValues;
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static boolean isMessyCode(String strName) {
        try {
            Pattern p = Pattern.compile("\\s*|\t*|\r*|\n*");
            Matcher m = p.matcher(strName);
            String after = m.replaceAll("");
            String temp = after.replaceAll("\\p{P}", "");
            char[] ch = temp.trim().toCharArray();
            int length = ch != null ? ch.length : 0;
            for (int i = 0; i < length; ++i) {
                String str;
                char c = ch[i];
                if (Character.isLetterOrDigit(c) || (str = "" + ch[i]).matches("[\u4e00-\u9fa5]+")) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String trimDiagonal(String filename) {
        if (filename.startsWith("/")) {
            filename = filename.substring(1, filename.length());
            return StringUtils.trimDiagonal(filename);
        }
        return filename;
    }

    public static String convertArrayToString(String[] arr) {
        return StringUtils.convertArrayToString(arr, COMMA);
    }

    public static String convertArrayToString(String[] arr, String split) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]);
            sb.append(split);
        }
        return sb.substring(0, sb.length() - split.length());
    }

    public static String convertCollectionAsString(Collection<String> strs) {
        return StringUtils.convertCollectionAsString(strs, COMMA);
    }

    public static String convertCollectionAsString(Collection<String> strs, String split) {
        if (strs == null || strs.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = strs.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            sb.append(split);
        }
        return sb.substring(0, sb.length() - split.length());
    }

    public static String upperFirst(String str) {
        return StringUtils.toFirst(str, true);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isZeroEmpty(String tmp) {
        boolean isEmpty = StringUtils.isEmpty(tmp);
        if (isEmpty) {
            return true;
        }
        return "0".equals(tmp);
    }

    public static boolean isNotZeroEmpty(String tmp) {
        return !StringUtils.isZeroEmpty(tmp);
    }

    public static String lowerFirst(String str) {
        return StringUtils.toFirst(str, false);
    }

    public static String toFirst(String str, boolean isUpper) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        char first = str.charAt(0);
        String firstChar = new String(new char[]{first});
        firstChar = isUpper ? firstChar.toUpperCase() : firstChar.toLowerCase();
        return firstChar + str.substring(1);
    }

    public static String replaceVariable(String content, String replace) {
        return StringUtils.replaceVariable(content, replace, "\\{(.*?)\\}");
    }

    public static String replaceVariable(String content, String replace, String regular) {
        Pattern regex = Pattern.compile(regular);
        String result = content;
        Matcher regexMatcher = regex.matcher(result);
        while (regexMatcher.find()) {
            String toReplace = regexMatcher.group(0);
            result = result.replace(toReplace, replace);
            regexMatcher = regex.matcher(result);
        }
        return result;
    }

    public static String replaceVariableMap(String content, Map<String, Object> map) throws Exception {
        return StringUtils.replaceVariableMap(content, map, "\\{(.*?)\\}");
    }

    public static String replaceVariableMap(String template, Map<String, Object> map, String regular) throws Exception {
        Pattern regex = Pattern.compile(regular);
        Matcher regexMatcher = regex.matcher(template);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            String toReplace = regexMatcher.group(0);
            String value = (String)map.get(key);
            if (value != null) {
                template = template.replace(toReplace, value);
                continue;
            }
            throw new Exception("\u6ca1\u6709\u627e\u5230[" + key + "]\u5bf9\u5e94\u7684\u53d8\u91cf\u503c\uff0c\u8bf7\u68c0\u67e5\u8868\u53d8\u91cf\u914d\u7f6e!");
        }
        return template;
    }

    public static byte[] stringToBytes(String str) {
        byte[] digest = new byte[str.length() / 2];
        for (int i = 0; i < digest.length; ++i) {
            String byteString = str.substring(2 * i, 2 * i + 2);
            int byteValue = Integer.parseInt(byteString, 16);
            digest[i] = (byte)byteValue;
        }
        return digest;
    }

    public static String bytesToString(byte[] b) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String plainText = Integer.toHexString(0xFF & b[i]);
            if (plainText.length() < 2) {
                plainText = "0" + plainText;
            }
            hexString.append(plainText);
        }
        return hexString.toString();
    }

    public static String encodingString(String str, String from, String to) {
        String result = str;
        try {
            result = new String(str.getBytes(from), to);
        }
        catch (Exception e) {
            result = str;
        }
        return result;
    }

    public static String trimSufffix(String toTrim, String trimStr) {
        while (toTrim.endsWith(trimStr)) {
            toTrim = toTrim.substring(0, toTrim.length() - trimStr.length());
        }
        return toTrim;
    }

    public static String convertDbFieldToField(String dbField) {
        return StringUtils.convertDbFieldToField(dbField, "_", true);
    }

    public static String convertDbFieldToField(String dbField, String symbol, boolean isIgnoreFirst) {
        String result = "";
        if (dbField.startsWith(symbol)) {
            dbField = dbField.substring(1);
        }
        if (dbField.endsWith(symbol)) {
            dbField = dbField.substring(0, dbField.length() - 1);
        }
        String[] arr = dbField.split(symbol);
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i];
            if (isIgnoreFirst && i != 0) {
                char oldChar = str.charAt(0);
                char newChar = (oldChar + "").toUpperCase().charAt(0);
                str = newChar + str.substring(1);
            }
            result = result + str;
        }
        return result;
    }

    public static String[] getStringAryByStr(String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        String[] aryId = str.split(",");
        String[] lAryId = new String[aryId.length];
        for (int i = 0; i < aryId.length; ++i) {
            lAryId[i] = aryId[i];
        }
        return lAryId;
    }

    public static String trimSuffix(String content, String suffix) {
        String resultStr = content;
        while (resultStr.endsWith(suffix)) {
            resultStr = resultStr.substring(0, resultStr.length() - suffix.length());
        }
        return resultStr;
    }

    public static String trimPrefix(String content, String prefix) {
        String resultStr = content;
        while (resultStr.startsWith(prefix)) {
            resultStr = resultStr.substring(prefix.length());
        }
        return resultStr;
    }
}

