/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void decompress(String fileName, String outputPath) {
        File dir;
        if (!outputPath.endsWith(File.separator)) {
            outputPath = outputPath + File.separator;
        }
        if (!(dir = new File(outputPath)).exists()) {
            dir.mkdirs();
        }
        JarFile jf = null;
        try {
            jf = new JarFile(fileName);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                int nBytes;
                JarEntry je = e.nextElement();
                String outFileName = outputPath + je.getName();
                File f = new File(outFileName);
                if (je.isDirectory()) {
                    if (f.exists()) continue;
                    f.mkdirs();
                    continue;
                }
                File pf = f.getParentFile();
                if (!pf.exists()) {
                    pf.mkdirs();
                }
                InputStream in = jf.getInputStream(je);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buffer = new byte[2048];
                while ((nBytes = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, nBytes);
                }
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (Exception e) {
            System.out.println("\u89e3\u538b" + fileName + "\u51fa\u9519\uff01" + e.getMessage());
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

