/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.sms.disruptor;

import com.ailikes.common.sms.config.SmsConfigProperties;
import com.ailikes.common.sms.disruptor.SmsDao;
import com.ailikes.common.sms.disruptor.SmsData;
import com.ailikes.common.sms.disruptor.SmsEvent;
import com.ailikes.common.sms.disruptor.SmsHandlerCallBack;
import com.lmax.disruptor.RingBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsEventProducer {
    private static Logger logger = LoggerFactory.getLogger(SmsEventProducer.class);
    private final RingBuffer<SmsEvent> ringBuffer;
    private SmsDao smsDao;

    public SmsEventProducer(RingBuffer<SmsEvent> ringBuffer, SmsDao smsDao) {
        this.ringBuffer = ringBuffer;
        this.smsDao = smsDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendSms(String eventId, SmsData smsData, SmsHandlerCallBack callBack) {
        long sequence = this.ringBuffer.next();
        try {
            SmsEvent smsEvent = (SmsEvent)this.ringBuffer.get(sequence);
            smsEvent.setId(eventId);
            smsEvent.setSmsData(smsData);
            smsEvent.setHandlerCallBack(callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
        return eventId;
    }

    private String sendSms(String eventId, SmsData smsData) {
        return this.sendSms(eventId, smsData, null);
    }

    public String sendSms(String eventId, String phone, String smsTemplate, SmsConfigProperties smsConfigProperties, Map<String, Object> datas) {
        SmsData smsData = new SmsData();
        smsData.setPhone(phone);
        smsData.setSmsTemplate(smsTemplate);
        smsData.setDatas(datas);
        smsData.setSmsConfigProperties(smsConfigProperties);
        return this.sendSms(eventId, smsData);
    }

    public String sendSms(String eventId, String phone, String smsTemplate, SmsConfigProperties smsConfigProperties, Map<String, Object> datas, SmsHandlerCallBack callBack) {
        SmsData smsData = new SmsData();
        smsData.setPhone(phone);
        smsData.setSmsTemplate(smsTemplate);
        smsData.setDatas(datas);
        smsData.setSmsConfigProperties(smsConfigProperties);
        return this.sendSms(eventId, smsData, callBack);
    }
}

