/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.sms.client;

import com.ailikes.common.sms.client.ISmsClient;
import com.ailikes.common.sms.config.SmsConfigProperties;
import com.ailikes.common.sms.data.SmsResult;
import com.ailikes.common.sms.exception.SmsException;
import com.ailikes.common.sms.utils.huyi.HuyiRestSDK;
import com.ailikes.common.utils.mapper.JsonMapper;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;

public class HuyiSmsClient
implements ISmsClient {
    static final String serverUrl = "http://106.ihuyi.com/webservice/sms.php";
    private Boolean isOpen;
    private String signName;
    private String accountApiId = "";
    private String accountApikey = "";
    private SmsConfigProperties smsConfigProperties;
    private HuyiRestSDK huyiRestSDK;

    @Override
    public void init(SmsConfigProperties smsConfigProperties) {
        this.smsConfigProperties = smsConfigProperties;
        this.isOpen = this.smsConfigProperties.getOpen();
        this.signName = this.smsConfigProperties.getSignName();
        this.accountApiId = this.smsConfigProperties.getHuyi().getAccountApiId();
        this.accountApikey = this.smsConfigProperties.getHuyi().getAccountApiKey();
        try {
            this.huyiRestSDK = new HuyiRestSDK();
            this.huyiRestSDK.init(serverUrl);
            this.huyiRestSDK.setAccount(this.accountApiId, this.accountApikey);
        }
        catch (Exception e) {
            throw new SmsException("\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @Override
    public SmsResult send(String phone, String template) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        return this.send(phone, template, datas);
    }

    @Override
    public SmsResult send(String phone, String template, Map<String, Object> datas) {
        SmsResult smsResult;
        if (!this.isOpen.booleanValue()) {
            return SmsResult.success("\u6d4b\u8bd5\u6210\u529f");
        }
        try {
            String content = this.parseSmsContent(template, datas);
            Map<String, Object> result = this.huyiRestSDK.sendMsg(phone, content);
            if ("2".equals(result.get("code"))) {
                smsResult = SmsResult.success(result.get("msg") + "");
                smsResult.setSmsid(result.get("smsid") + "");
            } else {
                smsResult = SmsResult.fail(result.get("msg") + "");
            }
            smsResult.setReponseData(JsonMapper.toJsonString(result));
        }
        catch (IllegalArgumentException e) {
            smsResult = SmsResult.fail("\u53d1\u9001\u77ed\u4fe1\u63d0\u4ea4\u7684\u53c2\u6570\u4e0d\u5bf9");
        }
        catch (Exception e) {
            smsResult = SmsResult.fail(e.getMessage());
        }
        return smsResult;
    }

    public String parseSmsContent(String content, Map<String, Object> datas) {
        if (datas != null) {
            try {
                StringTemplateResourceLoader resourceLoader = new StringTemplateResourceLoader();
                Configuration cfg = Configuration.defaultConfiguration();
                GroupTemplate gt = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
                Template t = gt.getTemplate(content);
                t.binding(datas);
                content = t.render();
            }
            catch (Exception e) {
                throw new SmsException("\u6a21\u677f\u89e3\u6790\u5931\u8d25");
            }
        }
        return content;
    }
}

