/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.sms.client;

import com.ailikes.common.sms.client.ISmsClient;
import com.ailikes.common.sms.config.SmsConfigProperties;
import com.ailikes.common.sms.data.SmsResult;
import com.ailikes.common.sms.exception.SmsException;
import com.ailikes.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.HashMap;
import java.util.Map;

public class AliyunSmsClient
implements ISmsClient {
    static final String product = "Dysmsapi";
    static final String domain = "dysmsapi.aliyuncs.com";
    private Boolean isOpen;
    private String signName;
    private String accessKeyId;
    private String accessKeySecret;
    private SmsConfigProperties smsConfigProperties;
    private IAcsClient acsClient;

    @Override
    public void init(SmsConfigProperties smsConfigProperties) {
        this.smsConfigProperties = smsConfigProperties;
        this.isOpen = this.smsConfigProperties.getOpen();
        this.signName = this.smsConfigProperties.getSignName();
        this.accessKeyId = this.smsConfigProperties.getAliyun().getAccessKeyId();
        this.accessKeySecret = this.smsConfigProperties.getAliyun().getAccessKeySecret();
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.accessKeyId, (String)this.accessKeySecret);
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)product, (String)domain);
            this.acsClient = new DefaultAcsClient((IClientProfile)profile);
        }
        catch (Exception e) {
            throw new SmsException("\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @Override
    public SmsResult send(String phone, String template) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        return this.send(phone, template, datas);
    }

    @Override
    public SmsResult send(String phone, String template, Map<String, Object> datas) {
        if (!this.isOpen.booleanValue()) {
            return SmsResult.success("\u6d4b\u8bd5\u6210\u529f");
        }
        SmsResult smsResult = new SmsResult();
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");
            SendSmsRequest request = new SendSmsRequest();
            request.setPhoneNumbers(phone);
            request.setSignName(this.signName);
            request.setTemplateCode(template);
            request.setTemplateParam(JSON.toJSONString(datas));
            request.setSmsUpExtendCode(StringUtils.randomNumber((int)7));
            SendSmsResponse sendSmsResponse = (SendSmsResponse)this.acsClient.getAcsResponse((AcsRequest)request);
            smsResult = sendSmsResponse.getCode().equals("OK") ? SmsResult.success(sendSmsResponse.getMessage()) : SmsResult.fail(sendSmsResponse.getMessage());
            smsResult.setSmsid(request.getSmsUpExtendCode());
            smsResult.setReponseData(JSON.toJSONString((Object)sendSmsResponse));
        }
        catch (Exception e) {
            smsResult = SmsResult.fail(e.getMessage());
        }
        return smsResult;
    }
}

