/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.sms.disruptor;

import com.ailikes.common.sms.client.ISmsClient;
import com.ailikes.common.sms.config.SmsConfigProperties;
import com.ailikes.common.sms.data.SmsResult;
import com.ailikes.common.sms.disruptor.SmsDao;
import com.ailikes.common.sms.disruptor.SmsData;
import com.ailikes.common.sms.disruptor.SmsEvent;
import com.ailikes.common.sms.disruptor.SmsEventFactory;
import com.ailikes.common.sms.disruptor.SmsEventProducer;
import com.ailikes.common.sms.disruptor.SmsHandler;
import com.ailikes.common.sms.disruptor.SmsHandlerCallBack;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;

public class SmsHelper {
    private SmsDao smsDao = null;
    private int handlerCount = 1;
    private int bufferSize = 1024;
    private Disruptor<SmsEvent> disruptor;
    private SmsEventProducer smsEventProducer;
    private ISmsClient smsClient = null;

    public SmsHelper() {
    }

    public SmsHelper(int handlerCount, int bufferSize, ISmsClient smsClient) {
        this.handlerCount = handlerCount;
        this.bufferSize = bufferSize;
        this.smsClient = smsClient;
    }

    public ISmsClient getSmsClient() {
        return this.smsClient;
    }

    public void setSmsClient(ISmsClient smsClient) {
        this.smsClient = smsClient;
    }

    @PostConstruct
    private void start() {
        ExecutorService executor = Executors.newCachedThreadPool();
        SmsEventFactory factory = new SmsEventFactory();
        this.disruptor = new Disruptor((EventFactory)factory, this.bufferSize, (Executor)executor, ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        ArrayList<SmsHandler> smsHandlers = new ArrayList<SmsHandler>();
        for (int i = 0; i < this.handlerCount; ++i) {
            smsHandlers.add(new SmsHandler(this.smsClient, this.smsDao));
        }
        this.disruptor.handleExceptionsWith((ExceptionHandler)new IgnoreExceptionHandler());
        this.disruptor.handleEventsWithWorkerPool((WorkHandler[])smsHandlers.toArray(new SmsHandler[smsHandlers.size()]));
        this.disruptor.start();
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        this.smsEventProducer = new SmsEventProducer((RingBuffer<SmsEvent>)ringBuffer, this.smsDao);
    }

    public void shutdown() {
        this.doHalt();
    }

    private void doHalt() {
        this.disruptor.halt();
    }

    public String sendAsyncSms(String eventId, String phone, String smsTemplate, SmsConfigProperties smsConfigProperties, Map<String, Object> datas) {
        return this.smsEventProducer.sendSms(eventId, phone, smsTemplate, smsConfigProperties, datas);
    }

    public String sendAsyncSms(String eventId, String phone, String smsTemplate, SmsConfigProperties smsConfigProperties, Map<String, Object> datas, SmsHandlerCallBack callBack) {
        return this.smsEventProducer.sendSms(eventId, phone, smsTemplate, smsConfigProperties, datas, callBack);
    }

    public SmsResult sendSyncSms(String eventId, String phone, String smsTemplate, SmsConfigProperties smsConfigProperties, Map<String, Object> datas) {
        SmsData smsData = new SmsData();
        smsData.setPhone(phone);
        smsData.setSmsTemplate(smsTemplate);
        smsData.setSmsConfigProperties(smsConfigProperties);
        smsData.setDatas(datas);
        SmsEvent smsEvent = new SmsEvent();
        smsEvent.setId(eventId);
        smsEvent.setSmsData(smsData);
        SmsResult smsResult = this.smsClient.send(phone, smsTemplate, datas);
        if (this.smsDao != null) {
            this.smsDao.doResult(eventId, smsData, smsResult);
        }
        return smsResult;
    }

    public int getHandlerCount() {
        return this.handlerCount;
    }

    public void setHandlerCount(int handlerCount) {
        this.handlerCount = handlerCount;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public SmsDao getSmsDao() {
        return this.smsDao;
    }

    public void setSmsDao(SmsDao smsDao) {
        this.smsDao = smsDao;
    }
}

