/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.sms.client;

import com.ailikes.common.sms.client.ISmsClient;
import com.ailikes.common.sms.config.SmsConfigProperties;
import com.ailikes.common.sms.data.SmsResult;
import com.alibaba.fastjson.JSON;
import com.github.qcloudsms.SmsSingleSender;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.github.qcloudsms.httpclient.HTTPException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class TencentSmsClient
implements ISmsClient {
    private Boolean isOpen;
    private String signName;
    private SmsConfigProperties smsConfigProperties;
    private Integer appId = 0;
    private String appKey = "";

    @Override
    public void init(SmsConfigProperties smsConfigProperties) {
        this.smsConfigProperties = smsConfigProperties;
        this.isOpen = this.smsConfigProperties.getOpen();
        this.signName = this.smsConfigProperties.getSignName();
        this.appId = this.smsConfigProperties.getTencent().getAppId();
        this.appKey = this.smsConfigProperties.getTencent().getAppKey();
    }

    @Override
    public SmsResult send(String phone, String template) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        return this.send(phone, template, datas);
    }

    @Override
    public SmsResult send(String phone, String template, Map<String, Object> datas) {
        if (!this.isOpen.booleanValue()) {
            return SmsResult.success("\u6d4b\u8bd5\u6210\u529f");
        }
        SmsResult smsResult = new SmsResult();
        try {
            SmsSingleSender msender = new SmsSingleSender(this.appId.intValue(), this.appKey);
            SmsSingleSenderResult result = msender.sendWithParam("86", phone, Integer.parseInt(template), this.mapToList(datas), this.signName, "", "");
            smsResult = result.result == 0 ? SmsResult.success(result.errMsg) : SmsResult.fail(result.errMsg);
            smsResult.setSmsid(result.sid);
            smsResult.setReponseData(JSON.toJSONString((Object)result));
        }
        catch (HTTPException e) {
            e.printStackTrace();
            smsResult = SmsResult.fail("HTTP\u54cd\u5e94\u7801\u9519\u8bef");
        }
        catch (JSONException e) {
            e.printStackTrace();
            smsResult = SmsResult.fail("json\u89e3\u6790\u9519\u8bef");
        }
        catch (IOException e) {
            e.printStackTrace();
            smsResult = SmsResult.fail("\u7f51\u7edcIO\u9519\u8bef");
        }
        catch (Exception e) {
            smsResult = SmsResult.fail(e.getMessage());
        }
        return smsResult;
    }

    public ArrayList<String> mapToList(Map<String, Object> datas) {
        ArrayList<String> dataList = new ArrayList<String>();
        for (Map.Entry<String, Object> object : datas.entrySet()) {
            dataList.add(String.valueOf(object));
        }
        return dataList;
    }
}

