/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.session;

import com.ailikes.common.security.session.HttpSessionStore;
import com.ailikes.common.security.utils.AESUtil;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HttpSessionCookieStore
implements HttpSessionStore {
    private static final String sessionCookieName = "tmp_app";
    private static final char sep = '\u0001';
    private static final char sep2 = '\u0002';
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;
    private String key;

    public HttpSessionCookieStore(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) {
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.key = key;
    }

    @Override
    public void deseriable(HttpSession session) {
        Cookie[] cookies = this.httpServletRequest.getCookies();
        if (cookies == null || cookies.length == 0) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(sessionCookieName)) continue;
            try {
                String value = AESUtil.Decrypt(cookie.getValue(), this.key);
                String[] kvs = value.split("\u0002");
                if (kvs == null || kvs.length == 0) {
                    return;
                }
                for (String kv : kvs) {
                    String[] param = kv.split("\u0001");
                    if (param == null || param.length == 0 || param.length != 2) continue;
                    session.setAttribute(param[0], (Object)param[1]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void seriable(HttpSession session) {
        StringBuilder sb = new StringBuilder();
        Enumeration enums = session.getAttributeNames();
        while (enums.hasMoreElements()) {
            String name = (String)enums.nextElement();
            sb.append(name + '\u0001' + session.getAttribute(name) + '\u0002');
        }
        try {
            this.httpServletResponse.addCookie(this.getCookie(AESUtil.Encrypt(sb.toString(), this.key)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Cookie getCookie(String encrypt) {
        Cookie cookie = new Cookie(sessionCookieName, encrypt);
        return cookie;
    }
}

