/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.filter;

import com.ailikes.common.security.filter.base.SecurityFilter;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CsrfTokenCkeckFilter
implements SecurityFilter {
    private static final String CSRFTOKEN_PREFIX = "csrf_";

    @Override
    public void doFilterInvoke(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        if (httpRequest.getMethod().equals("POST")) {
            long paramCsrfToken;
            String csrfTokenKey = this.getTokenName(httpRequest);
            long csrfTokenId = (Long)httpRequest.getSession().getAttribute(csrfTokenKey);
            if (csrfTokenId != (paramCsrfToken = Long.parseLong(httpRequest.getParameter(csrfTokenKey)))) {
                throw new RuntimeException("post method csrf token not valid.");
            }
        }
    }

    private String getTokenName(HttpServletRequest httpRequest) {
        for (Map.Entry entry : httpRequest.getParameterMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith(CSRFTOKEN_PREFIX)) continue;
            return (String)entry.getKey();
        }
        return null;
    }
}

