/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.shiro.interceptor;

import com.ailikes.common.mvc.controller.BaseController;
import com.ailikes.common.security.shiro.authz.annotation.RolesAllowed;
import com.ailikes.common.security.shiro.interceptor.AnnotationsAuthorizingMethodInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class AuthorizationAdvisor
extends AuthorizationAttributeSourceAdvisor {
    private static final Class<? extends Annotation>[] AUTHZ_ANNOTATION_CLASSES = new Class[]{RolesAllowed.class, RequiresPermissions.class, RequiresRoles.class, RequiresUser.class, RequiresGuest.class, RequiresAuthentication.class};
    private static final Class<? extends Annotation>[] WEB_ANNOTATION_CLASSES = new Class[]{RequestMapping.class};

    public AuthorizationAdvisor() {
        this.setAdvice((Advice)new AnnotationsAuthorizingMethodInterceptor());
    }

    public boolean matches(Method method, Class targetClass) {
        boolean flag = super.matches(method, targetClass);
        if (!flag && this.isAuthzAnnotationPresent(targetClass) && this.isWebAnnotationPresent(method)) {
            flag = true;
        }
        return flag;
    }

    private boolean isAuthzAnnotationPresent(Class<BaseController> clazz) {
        for (Class<? extends Annotation> annClass : AUTHZ_ANNOTATION_CLASSES) {
            Annotation a = AnnotationUtils.findAnnotation(clazz, annClass);
            if (a == null) continue;
            return true;
        }
        return false;
    }

    private boolean isWebAnnotationPresent(Method method) {
        for (Class<? extends Annotation> annClass : WEB_ANNOTATION_CLASSES) {
            Annotation a = AnnotationUtils.findAnnotation((Method)method, annClass);
            if (a == null) continue;
            return true;
        }
        return false;
    }
}

