/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.filter.base;

import com.ailikes.common.security.constant.SecurityConstant;
import com.ailikes.common.security.utils.XssUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;

public class SecurityHttpServletRequest
extends HttpServletRequestWrapper {
    public SecurityHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        return XssUtil.xssFilter(super.getParameter(XssUtil.xssFilter(name, XssUtil.XssFilterTypeEnum.DELETE.getValue())), null);
    }

    public Map<String, String[]> getParameterMap() {
        Map paramsMap = super.getParameterMap();
        if (paramsMap == null || paramsMap.isEmpty()) {
            return paramsMap;
        }
        HashMap<String, String[]> resParamsMap = new HashMap<String, String[]>();
        for (Map.Entry entry : paramsMap.entrySet()) {
            resParamsMap.put(XssUtil.xssFilter((String)entry.getKey(), XssUtil.XssFilterTypeEnum.DELETE.getValue()), this.filterList((String[])entry.getValue()));
        }
        return resParamsMap;
    }

    public Enumeration<String> getParameterNames() {
        Enumeration enums = super.getParameterNames();
        Vector<String> vec = new Vector<String>();
        while (enums.hasMoreElements()) {
            String value = (String)enums.nextElement();
            vec.add(XssUtil.xssFilter(value, null));
        }
        return vec.elements();
    }

    public String[] getParameterValues(String name) {
        return this.filterList(super.getParameterValues(name));
    }

    private String[] filterList(String[] value) {
        if (value == null || value.length == 0) {
            return value;
        }
        ArrayList<String> resValueList = new ArrayList<String>();
        for (String val : value) {
            resValueList.add(XssUtil.xssFilter(val, null));
        }
        return resValueList.toArray(new String[resValueList.size()]);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        Collection parts = super.getParts();
        if (parts == null || parts.isEmpty() || SecurityConstant.whitefilePostFixList == null || SecurityConstant.whitefilePostFixList.isEmpty()) {
            return parts;
        }
        ArrayList<Part> resParts = new ArrayList<Part>();
        for (Part part : parts) {
            for (String extension : SecurityConstant.whitefilePostFixList) {
                if (!part.getName().toUpperCase().endsWith(extension)) continue;
                resParts.add(part);
            }
        }
        return resParts;
    }

    public Part getPart(String name) throws IOException, ServletException {
        Part part = super.getPart(name);
        if (SecurityConstant.whitefilePostFixList == null || SecurityConstant.whitefilePostFixList.isEmpty()) {
            return part;
        }
        String value = part.getHeader("content-disposition");
        String filename = value.substring(value.lastIndexOf("=") + 2, value.length() - 1);
        for (String extension : SecurityConstant.whitefilePostFixList) {
            if (!filename.toUpperCase().endsWith(extension.toUpperCase())) continue;
            return part;
        }
        return null;
    }
}

