/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.security.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XssUtil {
    private static String xssType = "<script[^>]*?>.*?</script>";
    private static Pattern xssPattern = Pattern.compile(xssType);

    public static String xssFilter(String input, String filterType) {
        Matcher matcher;
        if (input == null || input.isEmpty()) {
            return input;
        }
        if (filterType == null || !XssFilterTypeEnum.checkValid(filterType)) {
            filterType = XssFilterTypeEnum.ESCAPSE.getValue();
        }
        if (filterType.equals(XssFilterTypeEnum.ESCAPSE.getValue()) && (matcher = xssPattern.matcher(input)).find()) {
            return matcher.group().replace("<", "&lt;").replace(">", "&gt;");
        }
        if (filterType.equals(XssFilterTypeEnum.DELETE.getValue())) {
            return input.replaceAll(xssType, "");
        }
        return input;
    }

    public static enum XssFilterTypeEnum {
        ESCAPSE("escapse"),
        NO("no"),
        DELETE("delete");

        private String value;

        private XssFilterTypeEnum(String type) {
            this.value = type;
        }

        public String getValue() {
            return this.value;
        }

        public static boolean checkValid(String type) {
            if (type == null) {
                return false;
            }
            return ESCAPSE.getValue().equals(type) || NO.getValue().equals(type) || DELETE.getValue().equals(type);
        }
    }
}

